/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.convert;

import io.microsphere.collection.ListUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.convert.Converter;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ServiceLoaderUtils;
import io.microsphere.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class Converters
implements Utils {
    private static final ClassLoader classLoader = ClassLoaderUtils.getClassLoader(Converters.class);
    private static final ConcurrentMap<Map.Entry<Class<?>, Class<?>>, List<Converter>> convertersCache = Converters.initConvertersCache();

    static ConcurrentMap<Map.Entry<Class<?>, Class<?>>, List<Converter>> initConvertersCache() {
        List<Converter> convertersList = Converters.loadConvertersList();
        int size = convertersList.size();
        ConcurrentHashMap<Map.Entry<Class<?>, Class<?>>, List<Converter>> convertersCache = MapUtils.newConcurrentHashMap(size);
        for (int i = 0; i < size; ++i) {
            Converter converter = convertersList.get(i);
            Map.Entry key = MapUtils.immutableEntry(converter.getSourceType(), converter.getTargetType());
            List converters = convertersCache.computeIfAbsent(key, k -> ListUtils.newArrayList(4));
            converters.add(converter);
        }
        return convertersCache;
    }

    static <S, T> Converter<S, T> findConverter(Class<S> sourceType, Class<T> targetType) {
        Map.Entry<Class<S>, Class<T>> key = MapUtils.immutableEntry(sourceType, targetType);
        List converters = convertersCache.computeIfAbsent(key, k -> Converters.loadConvertersList().stream().filter(c -> c.accept(sourceType, targetType)).collect(Collectors.toList()));
        return (Converter)ListUtils.first(converters);
    }

    static List<Converter> loadConvertersList() {
        return ServiceLoaderUtils.loadServicesList(Converter.class, classLoader, true);
    }

    private Converters() {
    }
}

