/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.convert.multiple;

import io.microsphere.lang.Prioritized;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ServiceLoaderUtils;

public interface MultiValueConverter<S>
extends Prioritized {
    public boolean accept(Class<S> var1, Class<?> var2);

    public Object convert(S var1, Class<?> var2, Class<?> var3);

    default public Class<S> getSourceType() {
        return TypeUtils.resolveActualTypeArgumentClass(this.getClass(), MultiValueConverter.class, 0);
    }

    public static MultiValueConverter<?> find(Class<?> sourceType, Class<?> targetType) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(MultiValueConverter.class);
        return ServiceLoaderUtils.loadServicesList(MultiValueConverter.class, classLoader).stream().sorted().filter(converter -> converter.accept(sourceType, targetType)).findFirst().orElse(null);
    }

    public static <T> T convertIfPossible(Object source, Class<?> multiValueType, Class<?> elementType) {
        Class<?> sourceType = source.getClass();
        MultiValueConverter<?> converter = MultiValueConverter.find(sourceType, multiValueType);
        if (converter != null) {
            return (T)converter.convert(source, multiValueType, elementType);
        }
        return null;
    }
}

