/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.event;

import io.microsphere.annotation.Immutable;
import io.microsphere.event.ConditionalEventListener;
import io.microsphere.event.Event;
import io.microsphere.event.EventDispatcher;
import io.microsphere.event.EventListener;
import io.microsphere.event.Listenable;
import io.microsphere.util.ServiceLoaderUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractEventDispatcher
implements EventDispatcher {
    private final Object mutex = new Object();
    private final ConcurrentMap<Class<? extends Event>, List<EventListener>> listenersCache = new ConcurrentHashMap<Class<? extends Event>, List<EventListener>>();
    private final Executor executor;

    protected AbstractEventDispatcher(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor must not be null");
        }
        this.executor = executor;
        this.loadEventListenerInstances();
    }

    @Override
    public void addEventListener(EventListener<?> listener) throws NullPointerException, IllegalArgumentException {
        Listenable.assertListener(listener);
        this.doInListener(listener, listeners -> this.addIfAbsent((Collection)listeners, (Object)listener));
    }

    @Override
    public void removeEventListener(EventListener<?> listener) throws NullPointerException, IllegalArgumentException {
        Listenable.assertListener(listener);
        this.doInListener(listener, listeners -> listeners.remove(listener));
    }

    @Override
    @Immutable
    public List<EventListener<?>> getAllEventListeners() {
        LinkedList listeners = new LinkedList();
        this.sortedListeners().forEach(listener -> this.addIfAbsent(listeners, listener));
        return Collections.unmodifiableList(listeners);
    }

    protected Stream<EventListener> sortedListeners() {
        return this.sortedListeners(e -> true);
    }

    protected Stream<EventListener> sortedListeners(Predicate<? super Map.Entry<Class<? extends Event>, List<EventListener>>> predicate) {
        return this.listenersCache.entrySet().stream().filter(predicate).map(Map.Entry::getValue).flatMap(Collection::stream).sorted();
    }

    private <E> void addIfAbsent(Collection<E> collection, E element) {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    @Override
    public void dispatch(Event event) {
        Executor executor = this.getExecutor();
        executor.execute(() -> this.sortedListeners(entry -> ((Class)entry.getKey()).isAssignableFrom(event.getClass())).forEach(listener -> {
            ConditionalEventListener predicateEventListener;
            if (listener instanceof ConditionalEventListener && !(predicateEventListener = (ConditionalEventListener)listener).accept(event)) {
                return;
            }
            listener.onEvent(event);
        }));
    }

    @Override
    public final Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInListener(EventListener<?> listener, Consumer<Collection<EventListener>> consumer) {
        Class<Event> eventType = EventListener.findEventType(listener);
        if (eventType != null) {
            Object object = this.mutex;
            synchronized (object) {
                List listeners = this.listenersCache.computeIfAbsent(eventType, e -> new LinkedList());
                consumer.accept(listeners);
                Collections.sort(listeners);
            }
        }
    }

    protected void loadEventListenerInstances() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            ServiceLoaderUtils.loadServicesList(EventListener.class, classLoader).stream().sorted().forEach(this::addEventListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

