/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.event;

import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.event.EventListener;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;

public interface Listenable<E extends EventListener<?>> {
    public static void assertListener(EventListener<?> listener) throws IllegalArgumentException {
        Assert.assertNotNull(listener, () -> "The 'listener' must not be null.");
        Class<?> listenerClass = listener.getClass();
        int modifiers = listenerClass.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalArgumentException(FormatUtils.format("The listener[class : '{}'] must be non-final class", ClassUtils.getTypeName(listenerClass)));
        }
    }

    public void addEventListener(E var1) throws NullPointerException, IllegalArgumentException;

    default public void addEventListeners(E listener, E ... others) throws NullPointerException, IllegalArgumentException {
        ArrayList<E> listeners = new ArrayList<E>(1 + others.length);
        listeners.add(listener);
        CollectionUtils.addAll(listeners, others);
        this.addEventListeners(listeners);
    }

    default public void addEventListeners(Iterable<E> listeners) throws NullPointerException, IllegalArgumentException {
        StreamSupport.stream(listeners.spliterator(), false).forEach(this::addEventListener);
    }

    public void removeEventListener(E var1) throws NullPointerException, IllegalArgumentException;

    default public void removeEventListeners(Iterable<E> listeners) throws NullPointerException, IllegalArgumentException {
        StreamSupport.stream(listeners.spliterator(), false).forEach(this::removeEventListener);
    }

    default public void removeAllEventListeners() {
        this.removeEventListeners(this.getAllEventListeners());
    }

    @Nonnull
    public List<E> getAllEventListeners();
}

