/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.filter;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.filter.Filter;
import io.microsphere.filter.FilterOperator;
import io.microsphere.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class FilterUtils
implements Utils {
    @Nonnull
    @Immutable
    public static <E> List<E> filter(Iterable<E> iterable, Filter<E> filter) {
        return FilterUtils.filter(iterable, FilterOperator.AND, filter);
    }

    @Nonnull
    @Immutable
    public static <E> List<E> filter(Iterable<E> iterable, FilterOperator filterOperator, Filter<E> ... filters) {
        ArrayList<E> list = new ArrayList<E>();
        for (E element : iterable) {
            if (!filterOperator.accept(element, filters)) continue;
            list.add(element);
        }
        return Collections.unmodifiableList(list);
    }

    private FilterUtils() {
    }
}

