/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.filter;

import io.microsphere.filter.ClassFilter;

public class PackageNameClassFilter
implements ClassFilter {
    private final String packageName;
    private final boolean includedSubPackages;
    private final String subPackageNamePrefix;

    public PackageNameClassFilter(String packageName, boolean includedSubPackages) {
        this.packageName = packageName;
        this.includedSubPackages = includedSubPackages;
        this.subPackageNamePrefix = includedSubPackages ? packageName + "." : null;
    }

    @Override
    public boolean accept(Class<?> filteredObject) {
        if (filteredObject == null) {
            return false;
        }
        Package package_ = filteredObject.getPackage();
        String packageName = package_.getName();
        boolean accepted = packageName.equals(this.packageName);
        if (!accepted && this.includedSubPackages) {
            accepted = packageName.startsWith(this.subPackageNamePrefix);
        }
        return accepted;
    }
}

