/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.invoke;

import io.microsphere.lang.function.ThrowableBiFunction;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public abstract class MethodHandlesLookupUtils
implements Utils {
    public static final MethodHandle NOT_FOUND_METHOD_HANDLE = null;
    public static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

    public static MethodHandle findPublicVirtual(Class<?> requestedClass, String methodName, Class ... parameterTypes) {
        return MethodHandlesLookupUtils.findPublic(requestedClass, methodName, parameterTypes, (lookup, methodType) -> lookup.findVirtual(requestedClass, methodName, (MethodType)methodType));
    }

    public static MethodHandle findPublicStatic(Class<?> requestedClass, String methodName, Class ... parameterTypes) {
        return MethodHandlesLookupUtils.findPublic(requestedClass, methodName, parameterTypes, (lookup, methodType) -> lookup.findStatic(requestedClass, methodName, (MethodType)methodType));
    }

    protected static MethodHandle findPublic(Class<?> requestedClass, String methodName, Class[] parameterTypes, ThrowableBiFunction<MethodHandles.Lookup, MethodType, MethodHandle> function) {
        return MethodHandlesLookupUtils.find(PUBLIC_LOOKUP, requestedClass, methodName, parameterTypes, function);
    }

    protected static MethodHandle find(MethodHandles.Lookup lookup, Class<?> requestedClass, String methodName, Class[] parameterTypes, ThrowableBiFunction<MethodHandles.Lookup, MethodType, MethodHandle> function) {
        Method method = MethodUtils.findMethod(requestedClass, methodName, parameterTypes);
        return MethodHandlesLookupUtils.find(lookup, method, function);
    }

    protected static MethodHandle findPublic(Method method, ThrowableBiFunction<MethodHandles.Lookup, MethodType, MethodHandle> function) {
        return MethodHandlesLookupUtils.find(PUBLIC_LOOKUP, method, function);
    }

    protected static MethodHandle find(MethodHandles.Lookup lookup, Method method, ThrowableBiFunction<MethodHandles.Lookup, MethodType, MethodHandle> function) {
        if (method == null) {
            return NOT_FOUND_METHOD_HANDLE;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        MethodType methodType = ArrayUtils.isEmpty(parameterTypes) ? MethodType.methodType(returnType) : MethodType.methodType(returnType, parameterTypes);
        return ThrowableBiFunction.execute(lookup, methodType, function, (l, mt, e) -> {
            Logger logger = LoggerFactory.getLogger(MethodHandlesLookupUtils.class);
            if (logger.isWarnEnabled()) {
                logger.warn("The MethodHandle can't be found by Lookup[{}] on the method : {}", l, method, e);
            }
            return null;
        });
    }

    private MethodHandlesLookupUtils() {
    }
}

