/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Objects;

public class FastByteArrayInputStream
extends ByteArrayInputStream {
    public FastByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public FastByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastByteArrayInputStream)) {
            return false;
        }
        return Arrays.equals(this.buf, ((FastByteArrayInputStream)obj).buf);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buf});
    }
}

