/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.annotation.ConfigurationProperty;
import io.microsphere.io.FastByteArrayOutputStream;
import io.microsphere.io.StringBuilderWriter;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.nio.charset.CharsetUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.SystemUtils;
import io.microsphere.util.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class IOUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    static final String DEFAULT_BUFFER_SIZE_PROPERTY_VALUE = "2048";
    public static final int DEFAULT_BUFFER_SIZE = Integer.parseInt("2048");
    public static final String BUFFER_SIZE_PROPERTY_NAME = "microsphere.io.buffer.size";
    @ConfigurationProperty(name="microsphere.io.buffer.size", defaultValue="2048", description="The buffer size for I/O", source={"system-properties"})
    public static final int BUFFER_SIZE = Integer.getInteger("microsphere.io.buffer.size", DEFAULT_BUFFER_SIZE);

    public static byte[] toByteArray(InputStream in) throws IOException {
        if (in == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(BUFFER_SIZE);
        IOUtils.copy(in, out);
        return out.toByteArray();
    }

    public static String toString(InputStream in) throws IOException {
        return IOUtils.copyToString(in);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        return IOUtils.copyToString(in, encoding);
    }

    public static String toString(InputStream in, Charset charset) throws IOException {
        return IOUtils.copyToString(in, charset);
    }

    public static String toString(Reader reader) throws IOException {
        return IOUtils.copyToString(reader);
    }

    public static String copyToString(InputStream in, String encoding) throws IOException {
        String charset = StringUtils.isBlank(encoding) ? SystemUtils.FILE_ENCODING : encoding;
        return IOUtils.copyToString(in, Charset.forName(charset));
    }

    public static String copyToString(InputStream in) throws IOException {
        return IOUtils.copyToString(in, CharsetUtils.DEFAULT_CHARSET);
    }

    public static String copyToString(InputStream in, Charset charset) throws IOException {
        byte[] bytes = IOUtils.toByteArray(in);
        if (ArrayUtils.EMPTY_BYTE_ARRAY == bytes) {
            return null;
        }
        return new String(bytes, charset == null ? CharsetUtils.DEFAULT_CHARSET : charset);
    }

    public static String copyToString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilderWriter stringWriter = new StringBuilderWriter();
        IOUtils.copy(reader, stringWriter);
        return stringWriter.toString();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        Objects.requireNonNull(in, "No InputStream specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        if (logger.isTraceEnabled()) {
            logger.trace("Copied {} bytes[buffer size : {}] from InputStream[{}] to OutputStream[{}]", byteCount, BUFFER_SIZE, in, out);
        }
        return byteCount;
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        int charsRead;
        Objects.requireNonNull(reader, "No Reader specified");
        Objects.requireNonNull(writer, "No Writer specified");
        int charsCount = 0;
        char[] buffer = new char[BUFFER_SIZE];
        while ((charsRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charsRead);
            charsCount += charsRead;
        }
        writer.flush();
        if (logger.isTraceEnabled()) {
            logger.trace("Copied {} bytes[buffer size : {}] from Reader[{}] to Writer[{}]", charsCount, BUFFER_SIZE, reader, writer);
        }
        return charsCount;
    }

    public static void close(Closeable closeable) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace("The Closeable[{}] can't be closed", closeable, e);
            }
        }
    }

    private IOUtils() {
    }
}

