/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.util.ArrayUtils;
import io.microsphere.util.CharSequenceUtils;
import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private final StringBuilder builder;

    public StringBuilderWriter() {
        this(null);
    }

    public StringBuilderWriter(int capacity) {
        this(new StringBuilder(capacity));
    }

    public StringBuilderWriter(StringBuilder builder) {
        this.builder = builder != null ? builder : new StringBuilder();
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(char[] value) {
        if (ArrayUtils.isNotEmpty(value)) {
            this.builder.append(value, 0, value.length);
        }
    }

    @Override
    public void write(char[] value, int offset, int length) {
        if (ArrayUtils.isNotEmpty(value)) {
            this.builder.append(value, offset, length);
        }
    }

    @Override
    public void write(String value) {
        if (CharSequenceUtils.isNotEmpty(value)) {
            this.builder.append(value);
        }
    }

    @Override
    public void write(String value, int off, int len) {
        if (CharSequenceUtils.isNotEmpty(value)) {
            this.builder.append(value, off, len);
        }
    }

    @Override
    public Writer append(char value) {
        this.builder.append(value);
        return this;
    }

    @Override
    public Writer append(CharSequence value) {
        if (CharSequenceUtils.isNotEmpty(value)) {
            this.builder.append(value);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence value, int start, int end) {
        if (CharSequenceUtils.isNotEmpty(value)) {
            this.builder.append(value, start, end);
        }
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.builder.toString();
    }
}

