/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.event;

import io.microsphere.annotation.Immutable;
import io.microsphere.event.Event;
import java.io.File;

@Immutable
public class FileChangedEvent
extends Event {
    private final Kind kind;

    public FileChangedEvent(File file, Kind kind) throws IllegalArgumentException {
        super(file);
        if (kind == null) {
            throw new IllegalArgumentException("The 'kind' argument must not be null");
        }
        this.kind = kind;
    }

    public File getFile() {
        return (File)this.getSource();
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        String sb = "FileChangedEvent{kind=" + (Object)((Object)this.kind) + ", file=" + this.getFile() + '}';
        return sb;
    }

    public static enum Kind {
        CREATED,
        MODIFIED,
        DELETED;

    }
}

