/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.scanner;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.io.filter.IOFileFilter;
import io.microsphere.io.filter.TrueFileFilter;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SimpleFileScanner {
    public static final SimpleFileScanner INSTANCE = new SimpleFileScanner();

    @Nonnull
    @Immutable
    public Set<File> scan(File rootDirectory, boolean recursive) {
        return this.scan(rootDirectory, recursive, TrueFileFilter.INSTANCE);
    }

    @Nonnull
    @Immutable
    public Set<File> scan(File rootDirectory, boolean recursive, IOFileFilter ioFileFilter) {
        File[] subFiles;
        LinkedHashSet<File> filesSet = new LinkedHashSet<File>();
        if (ioFileFilter.accept(rootDirectory)) {
            filesSet.add(rootDirectory);
        }
        if ((subFiles = rootDirectory.listFiles()) != null) {
            for (File subFile : subFiles) {
                if (ioFileFilter.accept(subFile)) {
                    filesSet.add(subFile);
                }
                if (!recursive || !subFile.isDirectory()) continue;
                filesSet.addAll(this.scan(subFile, recursive, ioFileFilter));
            }
        }
        return Collections.unmodifiableSet(filesSet);
    }
}

