/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.scanner;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.filter.JarEntryFilter;
import io.microsphere.util.jar.JarUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SimpleJarEntryScanner {
    public static final SimpleJarEntryScanner INSTANCE = new SimpleJarEntryScanner();

    @Nonnull
    @Immutable
    public Set<JarEntry> scan(URL jarURL, boolean recursive) throws NullPointerException, IllegalArgumentException, IOException {
        return this.scan(jarURL, recursive, null);
    }

    @Nonnull
    @Immutable
    public Set<JarEntry> scan(URL jarURL, boolean recursive, JarEntryFilter jarEntryFilter) throws NullPointerException, IllegalArgumentException, IOException {
        String relativePath = JarUtils.resolveRelativePath(jarURL);
        JarFile jarFile = JarUtils.toJarFile(jarURL);
        return this.scan(jarFile, relativePath, recursive, jarEntryFilter);
    }

    public Set<JarEntry> scan(JarFile jarFile, boolean recursive) throws NullPointerException, IllegalArgumentException, IOException {
        return this.scan(jarFile, recursive, null);
    }

    @Nonnull
    @Immutable
    public Set<JarEntry> scan(JarFile jarFile, boolean recursive, JarEntryFilter jarEntryFilter) throws NullPointerException, IllegalArgumentException, IOException {
        return this.scan(jarFile, "", recursive, jarEntryFilter);
    }

    @Nonnull
    @Immutable
    protected Set<JarEntry> scan(JarFile jarFile, String relativePath, boolean recursive, JarEntryFilter jarEntryFilter) throws NullPointerException, IllegalArgumentException, IOException {
        LinkedHashSet<JarEntry> jarEntriesSet = new LinkedHashSet<JarEntry>();
        List<JarEntry> jarEntriesList = JarUtils.filter(jarFile, jarEntryFilter);
        for (JarEntry jarEntry : jarEntriesList) {
            String jarEntryName = jarEntry.getName();
            boolean accept = false;
            if (recursive) {
                accept = jarEntryName.startsWith(relativePath);
            } else if (jarEntry.isDirectory()) {
                accept = jarEntryName.equals(relativePath);
            } else {
                int beginIndex = jarEntryName.indexOf(relativePath);
                if (beginIndex == 0) {
                    boolean bl = accept = jarEntryName.indexOf("/", relativePath.length()) < 0;
                }
            }
            if (!accept) continue;
            jarEntriesSet.add(jarEntry);
        }
        return Collections.unmodifiableSet(jarEntriesSet);
    }
}

