/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.json;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.beans.BeanMetadata;
import io.microsphere.beans.BeanUtils;
import io.microsphere.collection.EnumerationUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.collection.QueueUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.convert.Converter;
import io.microsphere.json.JSONArray;
import io.microsphere.json.JSONException;
import io.microsphere.json.JSONObject;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.CharSequenceUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.ExceptionUtils;
import io.microsphere.util.IterableUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public abstract class JSONUtils
implements Utils {
    private static final String U2028 = "\\u2028";
    private static final String U2029 = "\\u2029";
    static final Class<?> UNKNOWN_CLASS = Void.class;
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static void append(StringBuilder jsonBuilder, String name, boolean value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, byte value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, short value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, int value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, long value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, float value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, double value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, char value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(value).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, Boolean value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Byte value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Short value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Integer value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Long value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Float value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Double value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Character value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(value).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, String value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(JSONUtils.escape(value)).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, Type value) {
        JSONUtils.append(jsonBuilder, name, value.getTypeName());
    }

    public static void append(StringBuilder jsonBuilder, String name, Object value) {
        JSONUtils.appendName(jsonBuilder, name);
        JSONUtils.appendValue(jsonBuilder, value);
    }

    public static void append(StringBuilder jsonBuilder, String name, boolean[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, byte[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, short[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, int[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, long[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, float[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, double[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, char[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, String[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Boolean[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Byte[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Short[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Integer[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Long[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Float[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Double[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Character[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static <T> void append(StringBuilder jsonBuilder, String name, T[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            JSONUtils.appendValue(jsonBuilder, values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void appendValue(StringBuilder jsonBuilder, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            JSONUtils.appendArray(jsonBuilder, value);
        } else if (Map.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendMap(jsonBuilder, (Map)value);
        } else if (Iterable.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendIterable(jsonBuilder, (Iterable)value);
        } else if (Character.class == valueClass || CharSequence.class.isAssignableFrom(valueClass) || Enum.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendString(jsonBuilder, value);
        } else if (Type.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendType(jsonBuilder, (Type)value);
        } else {
            jsonBuilder.append(value);
        }
    }

    static void appendArray(StringBuilder jsonBuilder, Object value) {
        jsonBuilder.append('[');
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            JSONUtils.appendValue(jsonBuilder, Array.get(value, i));
            if (i >= length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static StringBuilder appendName(StringBuilder jsonBuilder, String name) {
        if (StringUtils.isNotBlank(name)) {
            jsonBuilder.append('\"').append(name).append('\"').append(':');
        }
        return jsonBuilder;
    }

    static boolean isUnknownClass(Class<?> targetClass) {
        return UNKNOWN_CLASS == targetClass;
    }

    public static int length(JSONObject jsonObject) {
        return jsonObject == null ? 0 : jsonObject.length();
    }

    public static int length(JSONArray jsonArray) {
        return jsonArray == null ? 0 : jsonArray.length();
    }

    public static boolean isEmpty(JSONObject jsonObject) {
        return JSONUtils.length(jsonObject) == 0;
    }

    public static boolean isEmpty(JSONArray jsonArray) {
        return JSONUtils.length(jsonArray) == 0;
    }

    public static boolean isNotEmpty(JSONObject jsonObject) {
        return !JSONUtils.isEmpty(jsonObject);
    }

    public static boolean isNotEmpty(JSONArray jsonArray) {
        return !JSONUtils.isEmpty(jsonArray);
    }

    public static boolean isNull(Object object) {
        return JSONObject.NULL.equals(object);
    }

    public static boolean isNotNull(Object object) {
        return !JSONUtils.isNull(object);
    }

    public static boolean isJSONObject(Object value) {
        return value instanceof JSONObject;
    }

    public static boolean isJSONArray(Object value) {
        return value instanceof JSONArray;
    }

    @Nonnull
    public static JSONObject jsonObject(String json) throws IllegalArgumentException {
        JSONObject jsonObject;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException e) {
            throw ExceptionUtils.wrap(e, IllegalArgumentException.class);
        }
        return jsonObject;
    }

    @Nonnull
    public static JSONArray jsonArray(String json) throws IllegalArgumentException {
        JSONArray jsonArray;
        try {
            jsonArray = new JSONArray(json);
        }
        catch (JSONException e) {
            throw ExceptionUtils.wrap(e, IllegalArgumentException.class);
        }
        return jsonArray;
    }

    @Nonnull
    public static <V> V readValue(String json, Class<V> targetType) {
        return JSONUtils.readValue(JSONUtils.jsonObject(json), targetType);
    }

    @Nonnull
    public static <V> V readValue(JSONObject jsonObject, Class<V> targetType) {
        if (ClassUtils.isAssignableFrom(Map.class, targetType)) {
            return (V)JSONUtils.readValueAsMap(jsonObject);
        }
        return JSONUtils.readValueAsBean(jsonObject, targetType);
    }

    public static Map<String, Object> readValueAsMap(JSONObject jsonObject) {
        Map<String, Object> map = MapUtils.newFixedLinkedHashMap(jsonObject.length());
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = jsonObject.opt(key);
            map.put(key, JSONUtils.convertValue(value, Map.class));
        }
        return map;
    }

    @Nonnull
    public static <V> V readValueAsBean(JSONObject jsonObject, Class<V> beanClass) {
        BeanMetadata beanMetadata = BeanUtils.getBeanMetadata(beanClass);
        V valueObject = ClassUtils.newInstance(beanClass, new Object[0]);
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            Type propertyType;
            Object convertedValue;
            Method writeMethod;
            String key = iterator.next();
            Object value = jsonObject.opt(key);
            if (!JSONUtils.isNotNull(value) || (writeMethod = BeanUtils.findWriteMethod(beanMetadata, key)) == null || (convertedValue = JSONUtils.convertValue(value, propertyType = writeMethod.getGenericParameterTypes()[0])) == null) continue;
            MethodUtils.invokeMethod(valueObject, writeMethod, convertedValue);
        }
        return valueObject;
    }

    @Nullable
    public static <V> V readValues(String json, Class<V> multipleClass, Class<?> elementClass) {
        return JSONUtils.readValues(JSONUtils.jsonArray(json), multipleClass, elementClass);
    }

    @Nullable
    public static Object readValues(JSONArray jsonArray, Type targetType) {
        Class<?> elementClass;
        if (JSONUtils.isEmpty(jsonArray)) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtils.asParameterizedType(targetType);
        Class<?> multipleClass = null;
        if (parameterizedType == null) {
            elementClass = JSONUtils.determineElementClass(jsonArray);
        } else {
            multipleClass = TypeUtils.asClass(parameterizedType.getRawType());
            elementClass = TypeUtils.asClass(parameterizedType.getActualTypeArguments()[0]);
        }
        if (multipleClass == null) {
            if (elementClass != null) {
                return JSONUtils.readArray(jsonArray, elementClass);
            }
            return null;
        }
        return JSONUtils.readValues(jsonArray, multipleClass, elementClass);
    }

    @Nullable
    public static <V> V readValues(JSONArray jsonArray, Class<V> multipleClass, Class<?> elementClass) {
        if (ClassUtils.isArray(multipleClass)) {
            return (V)JSONUtils.readArray(jsonArray, multipleClass.getComponentType());
        }
        if (ListUtils.isList(multipleClass)) {
            return (V)JSONUtils.toList(jsonArray, elementClass);
        }
        if (SetUtils.isSet(multipleClass)) {
            return (V)JSONUtils.toSet(jsonArray, elementClass);
        }
        if (QueueUtils.isQueue(multipleClass)) {
            return (V)JSONUtils.toQueue(jsonArray, elementClass);
        }
        if (EnumerationUtils.isEnumeration(multipleClass)) {
            return (V)JSONUtils.toEnumeration(jsonArray, elementClass);
        }
        if (IterableUtils.isIterable(multipleClass)) {
            return (V)JSONUtils.toList(jsonArray, elementClass);
        }
        return null;
    }

    public static <E> E[] readArray(String json, Class<E> componentType) {
        return JSONUtils.readArray(JSONUtils.jsonArray(json), componentType);
    }

    public static <E> E[] readArray(JSONArray jsonArray, Class<E> componentType) {
        int length = jsonArray.length();
        Object[] array = (Object[])Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = jsonArray.opt(i);
            value = JSONUtils.convertValue(value, componentType);
            Array.set(array, i, value);
        }
        return array;
    }

    @Nullable
    public static String writeValueAsString(Object object) {
        Object wrapper = JSONObject.wrap(object);
        if (JSONUtils.isJSONObject(wrapper) || JSONUtils.isJSONArray(wrapper)) {
            return wrapper.toString();
        }
        return null;
    }

    @Nonnull
    public static String writeBeanAsString(Object javaBean) {
        Map<String, Object> properties = BeanUtils.resolvePropertiesAsMap(javaBean);
        JSONObject jsonObject = new JSONObject(properties);
        return jsonObject.toString();
    }

    @Nonnull
    public static Class<?> determineElementClass(JSONArray jsonArray) {
        int length = JSONUtils.length(jsonArray);
        Class targetClass = Object.class;
        for (int i = 0; i < length; ++i) {
            Object element = jsonArray.opt(i);
            Class<?> elementClass = element.getClass();
            if (i == 0) {
                targetClass = elementClass;
                continue;
            }
            if (elementClass == targetClass || targetClass.isAssignableFrom(elementClass)) continue;
            if (elementClass.isAssignableFrom(targetClass)) {
                targetClass = elementClass;
                continue;
            }
            targetClass = Object.class;
            break;
        }
        return targetClass;
    }

    public static String escape(@Nullable String v) {
        int length = CharSequenceUtils.length(v);
        if (length == 0) {
            return v;
        }
        int afterReplacement = 0;
        StringBuilder builder = null;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = v.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = U2028;
            } else {
                if (c != '\u2029') continue;
                replacement = U2029;
            }
            if (afterReplacement < i) {
                if (builder == null) {
                    builder = new StringBuilder(length);
                }
                builder.append(v, afterReplacement, i);
            }
            if (builder == null) {
                builder = new StringBuilder(length);
            }
            builder.append(replacement);
            afterReplacement = i + 1;
        }
        if (builder == null) {
            return v;
        }
        if (afterReplacement < length) {
            builder.append(v, afterReplacement, length);
        }
        return builder.toString();
    }

    static void appendMap(StringBuilder jsonBuilder, Map<String, Object> map) {
        jsonBuilder.append('{');
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        int i = 0;
        int size = entrySet.size();
        for (Map.Entry<String, Object> entry : entrySet) {
            String name = entry.getKey();
            Object value = entry.getValue();
            JSONUtils.append(jsonBuilder, name, value);
            if (i++ >= size - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append('}');
    }

    static void appendIterable(StringBuilder jsonBuilder, Iterable<?> values) {
        jsonBuilder.append('[');
        List<?> list = ListUtils.ofList(values);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            JSONUtils.appendValue(jsonBuilder, list.get(i));
            if (i >= size - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    static void appendString(StringBuilder jsonBuilder, Object value) {
        jsonBuilder.append('\"').append(value).append('\"');
    }

    static void appendType(StringBuilder jsonBuilder, Type value) {
        JSONUtils.appendString(jsonBuilder, value.getTypeName());
    }

    static Object convertValue(Object value, Type targetType) {
        if (JSONUtils.isNull(value)) {
            return null;
        }
        Class<?> valueClass = TypeUtils.asClass(targetType);
        if (JSONUtils.isJSONObject(value)) {
            return JSONUtils.readValue((JSONObject)value, valueClass);
        }
        if (JSONUtils.isJSONArray(value)) {
            JSONArray jsonArray = (JSONArray)value;
            return JSONUtils.readValues(jsonArray, targetType);
        }
        Object convertedValue = Converter.convertIfPossible(value, valueClass = ClassUtils.tryResolveWrapperType(valueClass));
        return convertedValue != null ? convertedValue : value;
    }

    static Enumeration<?> toEnumeration(JSONArray jsonArray, Class<?> elementClass) {
        ?[] array = JSONUtils.readArray(jsonArray, elementClass);
        return EnumerationUtils.ofEnumeration(array);
    }

    static List<?> toList(JSONArray jsonArray, Class<?> elementClass) {
        ArrayList list = ListUtils.newArrayList(jsonArray.length());
        JSONUtils.addValues(jsonArray, list, elementClass);
        return list;
    }

    static Queue<Object> toQueue(JSONArray jsonArray, Class<?> elementClass) {
        ArrayDeque<Object> queue = QueueUtils.newArrayDeque(jsonArray.length());
        JSONUtils.addValues(jsonArray, queue, elementClass);
        return queue;
    }

    static Set<Object> toSet(JSONArray jsonArray, Class<?> elementClass) {
        int length = jsonArray.length();
        Set<Object> sets = SetUtils.newFixedLinkedHashSet(length);
        JSONUtils.addValues(jsonArray, sets, elementClass);
        return sets;
    }

    static <C extends Collection> void addValues(JSONArray jsonArray, C collection, Class<?> elementClass) {
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            Object value = jsonArray.opt(i);
            value = JSONUtils.convertValue(value, elementClass);
            collection.add((Object)value);
        }
    }

    private JSONUtils() {
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JSONUtils.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JSONUtils.REPLACEMENT_CHARS[34] = "\\\"";
        JSONUtils.REPLACEMENT_CHARS[92] = "\\\\";
        JSONUtils.REPLACEMENT_CHARS[9] = "\\t";
        JSONUtils.REPLACEMENT_CHARS[8] = "\\b";
        JSONUtils.REPLACEMENT_CHARS[10] = "\\n";
        JSONUtils.REPLACEMENT_CHARS[13] = "\\r";
        JSONUtils.REPLACEMENT_CHARS[12] = "\\f";
    }
}

