/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.util.Version;
import java.io.Serializable;
import java.util.Objects;

@Immutable
public final class Deprecation
implements Serializable {
    private static final long serialVersionUID = 6380988834632455932L;
    @Nullable
    private final Version since;
    @Nullable
    private final String replacement;
    @Nullable
    private final String reason;
    @Nullable
    private final String link;
    @Nonnull
    private final Level level;

    Deprecation(Deprecation source) {
        this.since = source.since;
        this.replacement = source.replacement;
        this.reason = source.reason;
        this.link = source.link;
        this.level = source.level;
    }

    Deprecation(@Nullable Version since, @Nullable String replacement, @Nullable String reason, @Nullable String link, @Nullable Level level) {
        this.since = since;
        this.replacement = replacement;
        this.reason = reason;
        this.link = link;
        this.level = level == null ? Level.DEFAULT : level;
    }

    @Nullable
    public Version getSince() {
        return this.since;
    }

    @Nullable
    public String getReplacement() {
        return this.replacement;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public String getLink() {
        return this.link;
    }

    @Nonnull
    public Level getLevel() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Deprecation)) {
            return false;
        }
        Deprecation that = (Deprecation)o;
        return Objects.equals(this.since, that.since) && Objects.equals(this.replacement, that.replacement) && Objects.equals(this.reason, that.reason) && Objects.equals(this.link, that.link) && this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.since, this.replacement, this.reason, this.link, this.level});
    }

    public String toString() {
        return "Deprecation{since='" + this.since + '\'' + ", replacement='" + this.replacement + '\'' + ", reason='" + this.reason + '\'' + ", link='" + this.link + '\'' + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Deprecation of(String since) {
        return Deprecation.of(since, null);
    }

    public static Deprecation of(String since, String replacement) {
        return Deprecation.of(since, replacement, null);
    }

    public static Deprecation of(String since, String replacement, String reason) {
        return Deprecation.of(since, replacement, reason, null);
    }

    public static Deprecation of(String since, String replacement, String reason, String link) {
        return Deprecation.of(since, replacement, reason, link, Level.DEFAULT);
    }

    public static Deprecation of(String since, String replacement, String reason, String link, Level level) {
        return Deprecation.builder().since(since).replacement(replacement).reason(reason).link(link).level(level).build();
    }

    public static class Builder {
        @Nullable
        private Version since;
        @Nullable
        private String replacement;
        @Nullable
        private String reason;
        @Nullable
        private String link;
        @Nonnull
        private Level level;

        protected Builder() {
        }

        public Builder since(@Nullable String since) {
            return this.since(Version.of(since));
        }

        public Builder since(@Nullable Version since) {
            this.since = since;
            return this;
        }

        public Builder replacement(@Nullable String replacement) {
            this.replacement = replacement;
            return this;
        }

        public Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder link(@Nullable String link) {
            this.link = link;
            return this;
        }

        public Builder level(@Nullable Level level) {
            this.level = level == null ? Level.DEFAULT : level;
            return this;
        }

        public Deprecation build() {
            return new Deprecation(this.since, this.replacement, this.reason, this.link, this.level);
        }
    }

    public static enum Level {
        DEFAULT,
        REMOVAL;

    }
}

