/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang;

public class MutableInteger
extends Number {
    private int value;

    public MutableInteger(int value) {
        this.value = value;
    }

    public final int get() {
        return this.value;
    }

    public final MutableInteger set(int newValue) {
        this.value = newValue;
        return this;
    }

    public final int getAndSet(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public final int getAndIncrement() {
        return this.value++;
    }

    public final int getAndDecrement() {
        return this.value--;
    }

    public final int getAndAdd(int delta) {
        int oldValue = this.value;
        this.value = oldValue + delta;
        return oldValue;
    }

    public final int incrementAndGet() {
        return ++this.value;
    }

    public final int decrementAndGet() {
        return --this.value;
    }

    public int addAndGet(int delta) {
        int value;
        this.value = value = this.value + delta;
        return value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MutableInteger)) {
            return false;
        }
        return this.value == ((MutableInteger)obj).value;
    }

    public static MutableInteger of(int value) {
        return new MutableInteger(value);
    }
}

