/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.SetUtils;
import io.microsphere.lang.function.Predicates;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Streams {
    @Nonnull
    public static <T> Stream<T> stream(T ... values) {
        return Stream.of(values);
    }

    @Nonnull
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Nonnull
    public static <T> Stream<T> filterStream(T[] values, Predicate<? super T> predicate) {
        Stream<? super T> stream = Streams.stream(values);
        return stream.filter(predicate);
    }

    @Nonnull
    public static <T, S extends Iterable<T>> Stream<T> filterStream(S values, Predicate<? super T> predicate) {
        return Streams.stream(values).filter(predicate);
    }

    @Nonnull
    public static <T> List<T> filterList(T[] values, Predicate<? super T> predicate) {
        return Streams.filterList(Arrays.asList(values), predicate);
    }

    @Nonnull
    public static <T, S extends Iterable<T>> List<T> filterList(S values, Predicate<? super T> predicate) {
        return Streams.filterStream(values, predicate).collect(Collectors.toList());
    }

    @Nonnull
    public static <T> Set<T> filterSet(T[] values, Predicate<? super T> predicate) {
        return Streams.filterSet(SetUtils.ofSet(values), predicate);
    }

    @Nonnull
    public static <T, S extends Iterable<T>> Set<T> filterSet(S values, Predicate<? super T> predicate) {
        return Streams.filterStream(values, predicate).collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    @Nonnull
    public static <T, S extends Iterable<T>> S filter(S values, Predicate<? super T> predicate) {
        boolean isSet = SetUtils.isSet(values);
        return (S)(isSet ? Streams.filterSet(values, predicate) : Streams.filterList(values, predicate));
    }

    @Nonnull
    public static <T, S extends Iterable<T>> S filterAll(S values, Predicate<? super T> ... predicates) {
        return Streams.filter(values, Predicates.and(predicates));
    }

    @Nonnull
    public static <T> List<T> filterAllList(T[] values, Predicate<? super T> ... predicates) {
        return Streams.filterAll(Arrays.asList(values), Predicates.and(predicates));
    }

    @Nonnull
    public static <T> Set<T> filterAllSet(T[] values, Predicate<? super T> ... predicates) {
        return Streams.filterAll(SetUtils.ofSet(values), Predicates.and(predicates));
    }

    @Nonnull
    public static <T, S extends Iterable<T>> S filterAny(S values, Predicate<? super T> ... predicates) {
        return Streams.filter(values, Predicates.or(predicates));
    }

    @Nonnull
    public static <T> List<T> filterAnyList(T[] values, Predicate<? super T> ... predicates) {
        return Streams.filterAny(Arrays.asList(values), Predicates.or(predicates));
    }

    @Nonnull
    public static <T> Set<T> filterAnySet(T[] values, Predicate<? super T> ... predicates) {
        return Streams.filterAny(SetUtils.ofSet(values), Predicates.or(predicates));
    }

    @Nullable
    public static <T> T filterFirst(Iterable<T> values, Predicate<? super T> ... predicates) {
        return StreamSupport.stream(values.spliterator(), false).filter(Predicates.and(predicates)).findFirst().orElse(null);
    }
}

