/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.util.Assert;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface ThrowableConsumer<T> {
    public void accept(T var1) throws Throwable;

    default public void execute(T t) {
        this.execute(t, this::handleException);
    }

    default public void execute(T t, BiConsumer<T, Throwable> exceptionHandler) throws NullPointerException {
        Assert.assertNotNull(exceptionHandler, () -> "The 'exceptionHandler' must not be null");
        try {
            this.accept(t);
        }
        catch (Throwable e) {
            exceptionHandler.accept(t, e);
        }
    }

    default public void handleException(T t, Throwable failure) {
        throw new RuntimeException(failure);
    }

    public static <T> void execute(T t, ThrowableConsumer<T> consumer) throws NullPointerException {
        consumer.execute(t, consumer::handleException);
    }

    public static <T> void execute(T t, ThrowableConsumer<T> consumer, BiConsumer<T, Throwable> exceptionHandler) throws NullPointerException {
        Assert.assertNotNull(consumer, "The 'consumer' must not be null");
        consumer.execute(t, exceptionHandler);
    }
}

