/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.logging;

import io.microsphere.logging.Logger;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class AbstractLogger
implements Logger {
    private final String name;

    protected AbstractLogger(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(this::trace, this::trace, format, arguments);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(this::debug, this::debug, format, arguments);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(this::info, this::info, format, arguments);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(this::warn, this::warn, format, arguments);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(this::error, this::error, format, arguments);
    }

    protected void log(Consumer<String> messageHandler, BiConsumer<String, Throwable> messageThrowableHandler, String format, Object ... arguments) {
        String message;
        int length = ArrayUtils.length(arguments);
        if (length < 1) {
            message = format;
        } else {
            message = this.resolveMessage(format, arguments);
            Object lastArgument = arguments[length - 1];
            if (lastArgument instanceof Throwable) {
                messageThrowableHandler.accept(message, (Throwable)lastArgument);
            }
        }
        messageHandler.accept(message);
    }

    protected String resolveMessage(String format, Object ... arguments) {
        return FormatUtils.format(format, arguments);
    }
}

