/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.logging;

import io.microsphere.logging.AbstractLogger;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import java.util.logging.Level;

public class JDKLoggerFactory
extends LoggerFactory {
    public static final String JDK_LOGGER_CLASS_NAME = "java.util.logging.Logger";

    @Override
    protected String getDelegateLoggerClassName() {
        return JDK_LOGGER_CLASS_NAME;
    }

    @Override
    public Logger createLogger(String name) {
        return new JDKLogger(name);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    static class JDKLogger
    extends AbstractLogger {
        private final java.util.logging.Logger logger;

        JDKLogger(String name) {
            super(name);
            this.logger = java.util.logging.Logger.getLogger(name);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isLoggable(Level.ALL);
        }

        @Override
        public void trace(String message) {
            this.log(Level.ALL, message);
        }

        @Override
        public void trace(String message, Throwable t) {
            this.log(Level.ALL, message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String message) {
            this.log(Level.FINE, message);
        }

        @Override
        public void debug(String message, Throwable t) {
            this.log(Level.FINE, message, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isLoggable(Level.INFO);
        }

        @Override
        public void info(String message) {
            this.log(Level.INFO, message);
        }

        @Override
        public void info(String message, Throwable t) {
            this.log(Level.INFO, message, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String message) {
            this.log(Level.WARNING, message);
        }

        @Override
        public void warn(String message, Throwable t) {
            this.log(Level.WARNING, message, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isLoggable(Level.SEVERE);
        }

        @Override
        public void error(String message) {
            this.log(Level.SEVERE, message);
        }

        @Override
        public void error(String message, Throwable t) {
            this.log(Level.SEVERE, message, t);
        }

        boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }

        void log(Level level, String message) {
            this.logger.log(level, message);
        }

        void log(Level level, String msg, Throwable t) {
            this.logger.log(level, msg, t);
        }
    }
}

