/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.metadata;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.collection.ListUtils;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.metadata.ConfigurationPropertyLoader;
import io.microsphere.metadata.ConfigurationPropertyReader;
import io.microsphere.metadata.DefaultConfigurationPropertyReader;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassLoaderUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public abstract class ClassPathResourceConfigurationPropertyLoader
implements ConfigurationPropertyLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String resourceName;
    protected final ClassLoader classLoader;
    protected final boolean loadedAll;
    protected final ConfigurationPropertyReader configurationPropertyReader;

    protected ClassPathResourceConfigurationPropertyLoader(String resourceName) throws IllegalArgumentException {
        this(resourceName, false);
    }

    protected ClassPathResourceConfigurationPropertyLoader(@Nonnull String resourceName, @Nullable ClassLoader classLoader) {
        this(resourceName, classLoader, false);
    }

    protected ClassPathResourceConfigurationPropertyLoader(@Nonnull String resourceName, boolean loadedAll) {
        this(resourceName, null, loadedAll);
    }

    protected ClassPathResourceConfigurationPropertyLoader(@Nonnull String resourceName, @Nullable ClassLoader classLoader, boolean loadedAll) {
        Assert.assertNotEmpty(resourceName, () -> "The Class-Path resource must not be empty: " + resourceName);
        this.resourceName = resourceName;
        this.classLoader = classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
        this.loadedAll = loadedAll;
        this.configurationPropertyReader = new DefaultConfigurationPropertyReader();
    }

    @Override
    public final List<ConfigurationProperty> load() throws Throwable {
        LinkedList<ConfigurationProperty> configurationProperties = ListUtils.newLinkedList();
        if (this.loadedAll) {
            Enumeration<URL> urls = this.classLoader.getResources(this.resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.load(configurationProperties, url::openStream);
            }
        } else {
            this.load(configurationProperties, () -> this.classLoader.getResourceAsStream(this.resourceName));
        }
        return Collections.unmodifiableList(configurationProperties);
    }

    void load(List<ConfigurationProperty> configurationProperties, ThrowableSupplier<InputStream> streamSupplier) throws Throwable {
        try (InputStream inputStream = streamSupplier.get();){
            if (inputStream == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("The InputStream can't be open for the Class-Path resource: '{}', ClassLoader : {}", this.resourceName, this.classLoader);
                }
                return;
            }
            configurationProperties.addAll(this.configurationPropertyReader.read(inputStream));
        }
    }
}

