/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.metadata;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.ServiceLoaderUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public interface ConfigurationPropertyLoader
extends Prioritized {
    @Nullable
    public List<ConfigurationProperty> load() throws Throwable;

    @Nonnull
    @Immutable
    public static List<ConfigurationProperty> loadAll() {
        Logger logger = LoggerFactory.getLogger(ConfigurationPropertyLoader.class);
        List<ConfigurationPropertyLoader> loaders = ServiceLoaderUtils.loadServicesList(ConfigurationPropertyLoader.class);
        LinkedList<ConfigurationProperty> configurationProperties = ListUtils.newLinkedList();
        for (ConfigurationPropertyLoader loader : loaders) {
            try {
                List<ConfigurationProperty> loadedProperties = loader.load();
                if (!CollectionUtils.isNotEmpty(loadedProperties)) continue;
                configurationProperties.addAll(loadedProperties);
            }
            catch (Throwable e) {
                logger.error("Failed to load the instances of configuration property via {}", ClassUtils.getTypeName(loader.getClass()), e);
            }
        }
        return Collections.unmodifiableList(configurationProperties);
    }
}

