/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.metadata;

import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.json.JSONUtils;
import io.microsphere.metadata.ConfigurationPropertyGenerator;
import io.microsphere.util.Assert;
import java.util.Set;

public class DefaultConfigurationPropertyGenerator
implements ConfigurationPropertyGenerator {
    @Override
    public String generate(ConfigurationProperty configurationProperty) {
        Object defaultValue;
        Assert.assertNotNull((Object)configurationProperty, () -> "The 'ConfigurationProperty' argument must not be null");
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append('{');
        String name = configurationProperty.getName();
        JSONUtils.append(jsonBuilder, "name", name);
        String type = configurationProperty.getType();
        jsonBuilder.append(',');
        JSONUtils.append(jsonBuilder, "type", type);
        Object value = configurationProperty.getValue();
        if (value != null) {
            jsonBuilder.append(',');
            JSONUtils.append(jsonBuilder, "value", value);
        }
        if ((defaultValue = configurationProperty.getDefaultValue()) != null) {
            jsonBuilder.append(',');
            JSONUtils.append(jsonBuilder, "defaultValue", defaultValue);
        }
        jsonBuilder.append(',');
        JSONUtils.append(jsonBuilder, "required", configurationProperty.isRequired());
        String description = configurationProperty.getDescription();
        if (description != null) {
            jsonBuilder.append(',');
            JSONUtils.append(jsonBuilder, "description", description);
        }
        jsonBuilder.append(',');
        JSONUtils.appendName(jsonBuilder, "metadata");
        jsonBuilder.append(this.generate(configurationProperty.getMetadata()));
        jsonBuilder.append('}');
        return jsonBuilder.toString();
    }

    String generate(ConfigurationProperty.Metadata metadata) {
        int lastIndex;
        String declaredField;
        String declaredClass;
        Set<String> targets;
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append('{');
        Set<String> sources = metadata.getSources();
        if (CollectionUtils.isNotEmpty(sources)) {
            JSONUtils.append(jsonBuilder, "sources", sources);
            jsonBuilder.append(',');
        }
        if (CollectionUtils.isNotEmpty(targets = metadata.getTargets())) {
            JSONUtils.append(jsonBuilder, "targets", targets);
            jsonBuilder.append(',');
        }
        if ((declaredClass = metadata.getDeclaredClass()) != null) {
            JSONUtils.append(jsonBuilder, "declaredClass", declaredClass);
            jsonBuilder.append(',');
        }
        if ((declaredField = metadata.getDeclaredField()) != null) {
            JSONUtils.append(jsonBuilder, "declaredField", declaredField);
            jsonBuilder.append(',');
        }
        if (jsonBuilder.charAt(lastIndex = jsonBuilder.length() - 1) == ',') {
            jsonBuilder.deleteCharAt(lastIndex);
        }
        jsonBuilder.append('}');
        return jsonBuilder.toString();
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

