/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.metadata;

import io.microsphere.beans.ConfigurationProperty;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.json.JSONUtils;
import io.microsphere.metadata.ConfigurationPropertyReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultConfigurationPropertyReader
implements ConfigurationPropertyReader {
    @Override
    public List<ConfigurationProperty> read(String content) throws Throwable {
        List configurationPropertiesMaps = JSONUtils.readValues(content, List.class, Map.class);
        int size = configurationPropertiesMaps.size();
        ArrayList<ConfigurationProperty> configurationProperties = ListUtils.newArrayList(size);
        for (int i = 0; i < size; ++i) {
            Map configurationPropertyMap = (Map)configurationPropertiesMaps.get(i);
            ConfigurationProperty configurationProperty = this.readConfigurationProperty(configurationPropertyMap);
            configurationProperties.add(configurationProperty);
        }
        return Collections.unmodifiableList(configurationProperties);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    ConfigurationProperty readConfigurationProperty(Map<String, Object> configurationPropertyMap) {
        String name = (String)configurationPropertyMap.get("name");
        String type = (String)configurationPropertyMap.get("type");
        Object value = configurationPropertyMap.get("value");
        Object defaultValue = configurationPropertyMap.get("defaultValue");
        boolean required = (Boolean)configurationPropertyMap.get("required");
        String description = (String)configurationPropertyMap.get("description");
        ConfigurationProperty configurationProperty = new ConfigurationProperty(name);
        configurationProperty.setType(type);
        configurationProperty.setValue(value);
        configurationProperty.setDefaultValue(defaultValue);
        configurationProperty.setRequired(required);
        configurationProperty.setDescription(description);
        ConfigurationProperty.Metadata metadata = configurationProperty.getMetadata();
        this.initMetadata(metadata, configurationPropertyMap);
        return configurationProperty;
    }

    void initMetadata(ConfigurationProperty.Metadata metadata, Map<String, Object> configurationPropertyMap) {
        Map metadataMap = (Map)configurationPropertyMap.get("metadata");
        String[] sources = (String[])metadataMap.get("sources");
        String[] targets = (String[])metadataMap.get("targets");
        String declaredClass = (String)metadataMap.get("declaredClass");
        String declaredField = (String)metadataMap.get("declaredField");
        CollectionUtils.addAll(metadata.getSources(), sources);
        CollectionUtils.addAll(metadata.getSources(), targets);
        metadata.setDeclaredClass(declaredClass);
        metadata.setDeclaredField(declaredField);
    }
}

