/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.MapUtils;
import io.microsphere.net.CompositeURLStreamHandlerFactory;
import io.microsphere.net.DelegatingURLStreamHandlerFactory;
import io.microsphere.net.ExtendableProtocolURLStreamHandler;
import io.microsphere.net.MutableURLStreamHandlerFactory;
import io.microsphere.net.URLUtils;
import io.microsphere.util.ServiceLoaderUtils;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ServiceLoaderURLStreamHandlerFactory
extends DelegatingURLStreamHandlerFactory {
    public ServiceLoaderURLStreamHandlerFactory() {
        super(ServiceLoaderURLStreamHandlerFactory.createDelegate());
    }

    public static void attach() {
        ServiceLoaderURLStreamHandlerFactory factory = new ServiceLoaderURLStreamHandlerFactory();
        URLUtils.attachURLStreamHandlerFactory(factory);
    }

    private static URLStreamHandlerFactory createDelegate() {
        List<URLStreamHandlerFactory> factories = ServiceLoaderUtils.loadServicesList(URLStreamHandlerFactory.class);
        MutableURLStreamHandlerFactory<ExtendableProtocolURLStreamHandler> fallbackFactory = new MutableURLStreamHandlerFactory<ExtendableProtocolURLStreamHandler>(ServiceLoaderURLStreamHandlerFactory.loadHandlers());
        CompositeURLStreamHandlerFactory compositeFactory = new CompositeURLStreamHandlerFactory((Iterable<URLStreamHandlerFactory>)factories);
        compositeFactory.addURLStreamHandlerFactory(fallbackFactory);
        return compositeFactory;
    }

    @Nonnull
    @Immutable
    private static Map<String, ExtendableProtocolURLStreamHandler> loadHandlers() {
        List<ExtendableProtocolURLStreamHandler> handlers = ServiceLoaderUtils.loadServicesList(ExtendableProtocolURLStreamHandler.class);
        int size = handlers.size();
        if (size < 1) {
            return Collections.emptyMap();
        }
        Map<String, ExtendableProtocolURLStreamHandler> handlersMap = MapUtils.toFixedMap(handlers, handler -> MapUtils.immutableEntry(handler.getProtocol(), handler));
        return handlersMap;
    }
}

