/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.AccessibleObjectUtils;
import io.microsphere.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class StandardURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardURLStreamHandlerFactory.class);
    private static final String defaultFactoryFieldName = "defaultFactory";
    private static final Field defaultFactoryField = FieldUtils.findField(URL.class, "defaultFactory");

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = this.createURLStreamHandlerFromDefaultFactory(protocol);
        if (handler == null) {
            String name = "sun.net.www.protocol." + protocol + "." + "Handler";
            try {
                Object o = Class.forName(name).newInstance();
                return (URLStreamHandler)o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handler;
    }

    URLStreamHandler createURLStreamHandlerFromDefaultFactory(String protocol) {
        if (defaultFactoryField == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("The 'defaultFactory' field can't be found in the class URL.");
            }
            return null;
        }
        URLStreamHandler handler = null;
        try {
            AccessibleObjectUtils.trySetAccessible(defaultFactoryField);
            URLStreamHandlerFactory factory = (URLStreamHandlerFactory)defaultFactoryField.get(null);
            handler = factory.createURLStreamHandler(protocol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }
}

