/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.Lists;
import io.microsphere.collection.MapUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.net.CompositeURLStreamHandlerFactory;
import io.microsphere.net.ExtendableProtocolURLStreamHandler;
import io.microsphere.net.MutableURLStreamHandlerFactory;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.CharSequenceUtils;
import io.microsphere.util.ClassPathUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.SystemUtils;
import io.microsphere.util.Utils;
import io.microsphere.util.jar.JarUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class URLUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(URLUtils.class);
    public static final String DEFAULT_ENCODING = SystemUtils.FILE_ENCODING;
    @Immutable
    public static final URL[] EMPTY_URL_ARRAY = ArrayUtils.EMPTY_URL_ARRAY;
    private static final int ARCHIVE_ENTRY_SEPARATOR_LENGTH = "!/".length();
    public static final String FILE_URL_PREFIX = "file:/";
    private static final int FILE_URL_PREFIX_LENGTH = "file:/".length();
    public static final String HANDLER_PACKAGES_PROPERTY_NAME = "java.protocol.handler.pkgs";
    public static final String DEFAULT_HANDLER_PACKAGE_PREFIX = "sun.net.www.protocol";
    public static final char HANDLER_PACKAGES_SEPARATOR_CHAR = '|';
    public static final String HANDLER_CONVENTION_CLASS_NAME = "Handler";
    public static final String SUB_PROTOCOL_MATRIX_NAME = "_sp";

    @Nonnull
    public static URL ofURL(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static String resolveArchiveEntryPath(URL archiveFileURL) throws NullPointerException {
        return URLUtils.doResolveArchiveEntryPath(archiveFileURL.getPath());
    }

    protected static String doResolveArchiveEntryPath(String path) {
        int beginIndex = URLUtils.indexOfArchiveEntry(path);
        if (beginIndex > -1) {
            String relativePath = path.substring(beginIndex + ARCHIVE_ENTRY_SEPARATOR_LENGTH);
            return URLUtils.decode(relativePath);
        }
        return null;
    }

    @Nonnull
    public static String resolveBasePath(URL url) throws NullPointerException {
        return URLUtils.resolvePath(url, false);
    }

    static String resolvePath(URL url, boolean includeArchiveEntryPath) {
        String protocol;
        switch (protocol = url.getProtocol()) {
            case "file": {
                return URLUtils.resolvePathFromFile(url);
            }
            case "jar": {
                return URLUtils.resolvePathFromJar(url, includeArchiveEntryPath);
            }
        }
        String path = url.getPath();
        int indexOfMatrixString = URLUtils.indexOfMatrixString(path);
        path = indexOfMatrixString > -1 ? path.substring(0, indexOfMatrixString) : path;
        return path;
    }

    static String resolvePathFromFile(URL url) {
        int index;
        String path = URLUtils.buildPath(url);
        if (SystemUtils.IS_OS_WINDOWS && (index = path.indexOf(47)) == 0) {
            path = path.substring(1);
        }
        return path;
    }

    static String buildPath(URL url) {
        int pathLength;
        String authority = url.getAuthority();
        String path = url.getPath();
        int length = 0;
        int authorityLength = CharSequenceUtils.length(authority);
        if (authorityLength > 0) {
            length += authority.length() + 1;
        }
        if ((pathLength = CharSequenceUtils.length(path)) > 0) {
            length += pathLength;
        }
        StringBuilder pathBuilder = new StringBuilder(length);
        if (authorityLength > 0) {
            pathBuilder.append('/').append(authority);
        }
        if (pathLength > 0) {
            pathBuilder.append(path);
        }
        return pathBuilder.toString();
    }

    static String resolvePathFromJar(URL url, boolean includeArchiveEntryPath) {
        int indexOfSlash;
        int indexOfColon;
        String path = URLUtils.buildPath(url);
        int filePrefixIndex = path.indexOf(FILE_URL_PREFIX);
        if (filePrefixIndex == 0) {
            path = path.substring(FILE_URL_PREFIX_LENGTH);
        }
        if (!includeArchiveEntryPath) {
            int indexOfArchiveEntry = URLUtils.indexOfArchiveEntry(path);
            String string = path = indexOfArchiveEntry > -1 ? path.substring(0, indexOfArchiveEntry) : path;
        }
        if ((indexOfColon = path.indexOf(58)) == -1 && (indexOfSlash = path.indexOf(47)) != 0) {
            path = '/' + path;
        }
        return path;
    }

    @Nullable
    public static File resolveArchiveFile(URL resourceURL) throws NullPointerException {
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            return URLUtils.resolveArchiveDirectory(resourceURL);
        }
        return URLUtils.doResolveArchiveFile(resourceURL);
    }

    protected static File doResolveArchiveFile(URL url) throws NullPointerException {
        String basePath = URLUtils.resolveBasePath(url);
        File archiveFile = new File(basePath);
        return archiveFile.exists() ? archiveFile : null;
    }

    protected static File resolveArchiveDirectory(URL resourceURL) {
        String resourcePath = new File(resourceURL.getFile()).toString();
        Set<String> classPaths = ClassPathUtils.getClassPaths();
        File archiveDirectory = null;
        for (String classPath : classPaths) {
            if (!resourcePath.contains(classPath)) continue;
            archiveDirectory = new File(classPath);
            break;
        }
        return archiveDirectory;
    }

    @Nonnull
    @Immutable
    public static Map<String, List<String>> resolveQueryParameters(String url) {
        String queryString = StringUtils.substringAfterLast(url, "?");
        return URLUtils.resolveParameters(queryString, '&');
    }

    @Nonnull
    @Immutable
    public static Map<String, List<String>> resolveMatrixParameters(String url) {
        int startIndex = url.indexOf(59);
        if (startIndex == -1) {
            return Collections.emptyMap();
        }
        int endIndex = url.indexOf(63);
        if (endIndex == -1) {
            endIndex = url.indexOf(35);
        }
        if (endIndex == -1) {
            endIndex = url.length();
        }
        String matrixString = url.substring(startIndex, endIndex);
        return URLUtils.resolveParameters(matrixString, ';');
    }

    @Nullable
    public static String normalizePath(String path) {
        if (StringUtils.isBlank(path)) {
            return path;
        }
        String resolvedPath = path.trim();
        while (resolvedPath.indexOf(92) > -1) {
            resolvedPath = resolvedPath.replace('\\', '/');
        }
        while (resolvedPath.contains("//")) {
            resolvedPath = StringUtils.replace(resolvedPath, "//", "/");
        }
        return resolvedPath;
    }

    @Nonnull
    public static String encode(String value) {
        return URLUtils.encode(value, DEFAULT_ENCODING);
    }

    @Nonnull
    public static String encode(String value, String encoding) throws IllegalArgumentException {
        String encodedValue = null;
        try {
            encodedValue = URLEncoder.encode(value, encoding);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return encodedValue;
    }

    @Nonnull
    public static String decode(String value) {
        return URLUtils.decode(value, DEFAULT_ENCODING);
    }

    @Nonnull
    public static String decode(String value, String encoding) throws IllegalArgumentException {
        String decodedValue = null;
        try {
            decodedValue = URLDecoder.decode(value, encoding);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return decodedValue;
    }

    public static boolean isDirectoryURL(URL url) {
        boolean isDirectory = false;
        if (url != null) {
            String protocol = url.getProtocol();
            try {
                if ("jar".equals(protocol)) {
                    JarEntry jarEntry;
                    JarFile jarFile = URLUtils.toJarFile(url);
                    String relativePath = JarUtils.resolveRelativePath(url);
                    isDirectory = "".equals(relativePath) ? true : (jarEntry = jarFile.getJarEntry(relativePath)) != null && jarEntry.isDirectory();
                } else if ("file".equals(protocol)) {
                    File classPathFile = new File(url.toURI());
                    isDirectory = classPathFile.isDirectory();
                }
            }
            catch (Exception e) {
                isDirectory = false;
            }
        }
        return isDirectory;
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        boolean flag = false;
        if ("file".equals(protocol)) {
            JarFile jarFile = URLUtils.toJarFile(url);
            flag = jarFile != null;
        } else if ("jar".equals(protocol)) {
            flag = true;
        }
        return flag;
    }

    public static boolean isArchiveURL(URL url) {
        String protocol = url.getProtocol();
        boolean flag = false;
        switch (protocol) {
            case "jar": 
            case "war": 
            case "ear": {
                flag = true;
                break;
            }
            case "file": {
                JarFile jarFile = URLUtils.toJarFile(url);
                flag = jarFile != null;
            }
        }
        return flag;
    }

    @Nullable
    public static JarFile toJarFile(URL url) {
        JarFile jarFile;
        block4: {
            String path = URLUtils.buildPath(url);
            File file = new File(path);
            if (!file.exists()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("The JarFile is not existed from the url : {}", url);
                }
                return null;
            }
            jarFile = null;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block4;
                logger.trace("The JarFile can't be open from the url : {}", url);
            }
        }
        return jarFile;
    }

    @Nonnull
    public static String buildURI(String ... paths) {
        int length = ArrayUtils.length(paths);
        if (length < 1) {
            return "/";
        }
        int capacity = 0;
        for (int i = 0; i < length; ++i) {
            capacity += CharSequenceUtils.length(paths[i]) + 1;
        }
        StringBuilder uriBuilder = new StringBuilder(capacity);
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            uriBuilder.append('/');
            uriBuilder.append(path);
        }
        return URLUtils.normalizePath(uriBuilder.toString());
    }

    @Nullable
    public static String buildMatrixString(Map<String, List<String>> matrixParameters) {
        if (MapUtils.isEmpty(matrixParameters)) {
            return null;
        }
        StringBuilder matrixStringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : matrixParameters.entrySet()) {
            String name = entry.getKey();
            if (SUB_PROTOCOL_MATRIX_NAME.equals(name)) continue;
            List<String> values = entry.getValue();
            matrixStringBuilder.append(URLUtils.buildMatrixString(name, values.toArray(StringUtils.EMPTY_STRING_ARRAY)));
        }
        return matrixStringBuilder.toString();
    }

    @Nonnull
    public static String buildMatrixString(String name, String ... values) {
        return URLUtils.buildString(name, values, ';', '=');
    }

    @Nonnull
    public static String toExternalForm(URL url) throws NullPointerException {
        int indexOfMatrixString;
        String protocol = url.getProtocol();
        String authority = url.getAuthority();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        String matrix = null;
        int authorityLen = CharSequenceUtils.length(authority);
        int pathLen = CharSequenceUtils.length(path);
        int queryLen = CharSequenceUtils.length(query);
        int refLen = CharSequenceUtils.length(ref);
        boolean hasAuthority = authorityLen > 0;
        boolean hasPath = pathLen > 0;
        boolean hasQuery = queryLen > 0;
        boolean hasRef = refLen > 0;
        boolean hasMatrix = false;
        int len = 1;
        if (hasAuthority) {
            protocol = URLUtils.reformProtocol(protocol, authority);
            authority = URLUtils.resolveAuthority(authority);
            len += 2 + authority.length();
        }
        if (hasPath && (indexOfMatrixString = URLUtils.indexOfMatrixString(path)) > -1) {
            hasMatrix = true;
            Map<String, List<String>> matrixParameters = URLUtils.resolveMatrixParameters(path);
            List<String> subProtocols = matrixParameters.getOrDefault(SUB_PROTOCOL_MATRIX_NAME, Collections.emptyList());
            protocol = URLUtils.reformProtocol(protocol, subProtocols);
            matrix = URLUtils.buildMatrixString(matrixParameters);
            path = URLUtils.resolvePath(path, indexOfMatrixString);
        }
        len += CharSequenceUtils.length(path);
        len += CharSequenceUtils.length(protocol);
        if (hasQuery) {
            len += 1 + queryLen;
        }
        if (hasRef) {
            len += 1 + refLen;
        }
        if (hasMatrix) {
            len += CharSequenceUtils.length(matrix);
        }
        StringBuilder result = new StringBuilder(len);
        result.append(protocol);
        result.append(':');
        if (hasAuthority) {
            result.append("//");
            result.append(authority);
        }
        if (hasPath) {
            result.append(path);
        }
        if (hasMatrix) {
            result.append(matrix);
        }
        if (hasQuery) {
            result.append('?');
            result.append(query);
        }
        if (hasRef) {
            result.append('#');
            result.append(ref);
        }
        return result.toString();
    }

    @Nullable
    public static String getSubProtocol(String url) {
        Map<String, List<String>> parameters = URLUtils.resolveMatrixParameters(url);
        return URLUtils.getFirst(parameters, SUB_PROTOCOL_MATRIX_NAME);
    }

    @Nonnull
    @Immutable
    public static List<String> resolveSubProtocols(URL url) {
        return URLUtils.resolveSubProtocols(url.toString());
    }

    @Nonnull
    @Immutable
    public static List<String> resolveSubProtocols(String url) {
        List<String> subProtocols;
        String subProtocolsString = URLUtils.findSubProtocolsString(url);
        if (subProtocolsString == null) {
            Map<String, List<String>> parameters = URLUtils.resolveMatrixParameters(url);
            subProtocols = parameters.get(SUB_PROTOCOL_MATRIX_NAME);
        } else {
            String[] values = StringUtils.split(subProtocolsString, ':');
            subProtocols = Lists.ofList(values);
        }
        return subProtocols == null ? Collections.emptyList() : Collections.unmodifiableList(subProtocols);
    }

    @Nullable
    public static String resolveProtocol(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }
        int indexOfColon = url.indexOf(58);
        if (indexOfColon < 1) {
            return null;
        }
        for (int i = 0; i <= indexOfColon; ++i) {
            if (!Character.isWhitespace(url.charAt(i))) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("The protocol content should not contain the whitespace[url : '{}' , index : {}]", url, i);
            }
            return null;
        }
        return url.substring(0, indexOfColon);
    }

    private static String findSubProtocolsString(String url) {
        int endIndex;
        int startIndex = url.indexOf(58);
        if (startIndex > -1 && (endIndex = url.indexOf("://", startIndex)) > startIndex) {
            return url.substring(startIndex, endIndex);
        }
        return null;
    }

    public static String resolveAuthority(URL url) {
        return URLUtils.resolveAuthority(url.getAuthority());
    }

    @Nullable
    public static String resolveAuthority(String authority) {
        return URLUtils.truncateMatrixString(authority);
    }

    @Nonnull
    public static String resolvePath(URL url) {
        return URLUtils.resolvePath(url, true);
    }

    public static void attachURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        CompositeURLStreamHandlerFactory compositeFactory;
        if (factory == null) {
            return;
        }
        URLStreamHandlerFactory oldFactory = URLUtils.getURLStreamHandlerFactory();
        if (oldFactory == null) {
            URL.setURLStreamHandlerFactory(factory);
            return;
        }
        if (oldFactory instanceof CompositeURLStreamHandlerFactory) {
            compositeFactory = (CompositeURLStreamHandlerFactory)oldFactory;
        } else {
            compositeFactory = new CompositeURLStreamHandlerFactory();
            compositeFactory.addURLStreamHandlerFactory(oldFactory);
            URLUtils.clearURLStreamHandlerFactory();
            URL.setURLStreamHandlerFactory(compositeFactory);
        }
        compositeFactory.addURLStreamHandlerFactory(factory);
    }

    @Nullable
    public static URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return (URLStreamHandlerFactory)FieldUtils.getStaticFieldValue(URL.class, "factory");
    }

    public static void registerURLStreamHandler(ExtendableProtocolURLStreamHandler handler) {
        URLUtils.registerURLStreamHandler(handler.getProtocol(), handler);
    }

    public static void registerURLStreamHandler(String protocol, URLStreamHandler handler) {
        MutableURLStreamHandlerFactory factory = URLUtils.getMutableURLStreamHandlerFactory(true);
        factory.addURLStreamHandler(protocol, handler);
        URLUtils.attachURLStreamHandlerFactory(factory);
    }

    public static void close(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    static String resolvePath(String value, int indexOfMatrixString) {
        return indexOfMatrixString > -1 ? value.substring(0, indexOfMatrixString) : value;
    }

    protected static String truncateMatrixString(String value) {
        int lastIndex = URLUtils.indexOfMatrixString(value);
        return lastIndex > -1 ? value.substring(0, lastIndex) : value;
    }

    protected static int indexOfMatrixString(String value) {
        return value == null ? -1 : value.indexOf(59);
    }

    protected static MutableURLStreamHandlerFactory getMutableURLStreamHandlerFactory() {
        return URLUtils.getMutableURLStreamHandlerFactory(false);
    }

    protected static MutableURLStreamHandlerFactory getMutableURLStreamHandlerFactory(boolean createIfAbsent) {
        URLStreamHandlerFactory oldFactory = URLUtils.getURLStreamHandlerFactory();
        MutableURLStreamHandlerFactory factory = URLUtils.findMutableURLStreamHandlerFactory(oldFactory);
        if (oldFactory instanceof CompositeURLStreamHandlerFactory) {
            factory = URLUtils.findMutableURLStreamHandlerFactory((CompositeURLStreamHandlerFactory)oldFactory);
        }
        if (factory == null && createIfAbsent) {
            factory = new MutableURLStreamHandlerFactory();
        }
        return factory;
    }

    private static MutableURLStreamHandlerFactory findMutableURLStreamHandlerFactory(CompositeURLStreamHandlerFactory compositeFactory) {
        URLStreamHandlerFactory factory;
        MutableURLStreamHandlerFactory target = null;
        Iterator<URLStreamHandlerFactory> iterator = compositeFactory.getFactories().iterator();
        while (iterator.hasNext() && (target = URLUtils.findMutableURLStreamHandlerFactory(factory = iterator.next())) == null) {
        }
        return target;
    }

    private static MutableURLStreamHandlerFactory findMutableURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        if (factory instanceof MutableURLStreamHandlerFactory) {
            return (MutableURLStreamHandlerFactory)factory;
        }
        return null;
    }

    protected static void clearURLStreamHandlerFactory() {
        FieldUtils.setStaticFieldValue(URL.class, "factory", null);
    }

    protected static String reformProtocol(String protocol, String spec) {
        List<String> subProtocols = URLUtils.resolveSubProtocols(spec);
        return URLUtils.reformProtocol(protocol, subProtocols);
    }

    protected static String reformProtocol(String protocol, List<String> subProtocols) {
        int size = CollectionUtils.size(subProtocols);
        if (size < 1) {
            return protocol;
        }
        StringJoiner protocolJoiner = new StringJoiner(":");
        protocolJoiner.add(protocol);
        for (int i = 0; i < size; ++i) {
            protocolJoiner.add(subProtocols.get(i));
        }
        return protocolJoiner.toString();
    }

    protected static Map<String, List<String>> resolveParameters(String paramsString, char separatorChar) {
        String[] params = StringUtils.split(paramsString, separatorChar);
        int paramsLen = ArrayUtils.length(params);
        if (paramsLen == 0) {
            return Collections.emptyMap();
        }
        Map parametersMap = MapUtils.newFixedLinkedHashMap(paramsLen);
        for (int i = 0; i < paramsLen; ++i) {
            String param = params[i];
            String[] nameAndValue = StringUtils.split(param, '=');
            int len = nameAndValue.length;
            if (len <= 0) continue;
            String name = nameAndValue[0];
            String value = len > 1 ? nameAndValue[1] : "";
            LinkedList<String> paramValueList = (LinkedList<String>)parametersMap.get(name);
            if (paramValueList == null) {
                paramValueList = new LinkedList<String>();
                parametersMap.put(name, paramValueList);
            }
            paramValueList.add(value);
        }
        return Collections.unmodifiableMap(parametersMap);
    }

    protected static String buildString(String name, String[] values, char separator, char joiner) {
        int len = ArrayUtils.length(values);
        if (len == 0) {
            return null;
        }
        int capacity = 2 * len + name.length();
        for (int i = 0; i < len; ++i) {
            capacity += CharSequenceUtils.length(values[i]);
        }
        StringBuilder stringBuilder = new StringBuilder(capacity);
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(separator).append(name).append(joiner).append(values[i]);
        }
        return stringBuilder.toString();
    }

    protected static String getFirst(Map<String, List<String>> parameters, String name) {
        List<String> values = parameters.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    private static int indexOfArchiveEntry(String path) {
        return path.indexOf("!/");
    }

    private URLUtils() {
    }
}

