/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.process;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.management.JmxUtils;
import io.microsphere.process.ProcessIdResolver;
import io.microsphere.util.StringUtils;

public class ClassicProcessIdResolver
implements ProcessIdResolver {
    private static final Logger logger = LoggerFactory.getLogger(ClassicProcessIdResolver.class);
    private static final String runtimeName = JmxUtils.getRuntimeMXBean().getName();
    private static final String processIdValue = StringUtils.substringBefore(runtimeName, "@");

    @Override
    public boolean supports() {
        return StringUtils.isNumeric(processIdValue);
    }

    @Override
    public Long current() {
        Long processId = Long.valueOf(processIdValue);
        if (logger.isTraceEnabled()) {
            logger.trace("The PID was resolved from the method 'java.lang.management.RuntimeMXBean#getName()' = {} : {}", runtimeName, processId);
        }
        return processId;
    }

    @Override
    public int getPriority() {
        return 9;
    }
}

