/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.process;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.process.ProcessIdResolver;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ClassLoaderUtils;

public class ModernProcessIdResolver
implements ProcessIdResolver {
    private static final Logger logger = LoggerFactory.getLogger(ModernProcessIdResolver.class);
    private static final String PROCESS_HANDLE_CLASS_NAME = "java.lang.ProcessHandle";
    private static final Class<?> PROCESS_HANDLE_CLASS = ClassLoaderUtils.resolveClass("java.lang.ProcessHandle");

    @Override
    public boolean supports() {
        return PROCESS_HANDLE_CLASS != null;
    }

    @Override
    public Long current() {
        Object processHandle = MethodUtils.invokeStaticMethod(PROCESS_HANDLE_CLASS, "current", new Object[0]);
        Long pid = (Long)MethodUtils.invokeMethod(processHandle, PROCESS_HANDLE_CLASS, "pid", new Object[0]);
        if (logger.isTraceEnabled()) {
            logger.trace("The PID was resolved from the method 'java.lang.ProcessHandle#pid()' : {}", pid);
        }
        return pid;
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

