/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.process;

import io.microsphere.process.ProcessManager;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;

public class ProcessExecutor {
    private static final long waitForTimeInSecond = Long.getLong("process.executor.wait.for", 1L);
    private final ProcessManager processManager = ProcessManager.INSTANCE;
    private final Runtime runtime = Runtime.getRuntime();
    private final String commandLine;
    private final String options;
    private boolean finished;

    public ProcessExecutor(String command, String ... options) {
        StringBuilder optionsBuilder = new StringBuilder();
        if (ArrayUtils.isNotEmpty(options)) {
            for (String argument : options) {
                optionsBuilder.append(' ').append(argument);
            }
        }
        this.options = optionsBuilder.toString();
        this.commandLine = command + this.options;
    }

    public void execute(OutputStream outputStream) throws IOException {
        try {
            this.execute(outputStream, Long.MAX_VALUE);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OutputStream outputStream, long timeoutInMilliseconds) throws IOException, TimeoutException {
        Process process = this.runtime.exec(this.commandLine);
        long startTime = System.currentTimeMillis();
        long endTime = -1L;
        InputStream processInputStream = process.getInputStream();
        InputStream processErrorInputStream = process.getErrorStream();
        int exitValue = -1;
        while (!this.finished) {
            long costTime = endTime - startTime;
            if (costTime > timeoutInMilliseconds) {
                this.finished = true;
                this.processManager.destroy(process);
                String message = FormatUtils.format("Execution is timeout[{} ms]!", timeoutInMilliseconds);
                throw new TimeoutException(message);
            }
            try {
                this.processManager.addUnfinishedProcess(process, this.options);
                while (processInputStream.available() > 0) {
                    outputStream.write(processInputStream.read());
                }
                while (processErrorInputStream.available() > 0) {
                    outputStream.write(processErrorInputStream.read());
                }
                exitValue = process.exitValue();
                if (exitValue != 0) {
                    throw new IOException();
                }
                this.finished = true;
            }
            catch (IllegalThreadStateException e) {
                this.waitFor(waitForTimeInSecond);
                endTime = System.currentTimeMillis();
            }
            finally {
                this.processManager.removeUnfinishedProcess(process, this.options);
            }
        }
    }

    private void waitFor(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

