/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.Lists;
import io.microsphere.lang.function.Streams;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.AccessibleObjectUtils;
import io.microsphere.reflect.ExecutableUtils;
import io.microsphere.reflect.MemberUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public abstract class ConstructorUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ConstructorUtils.class);
    public static final Constructor NOT_FOUND_CONSTRUCTOR = null;

    public static boolean isNonPrivateConstructorWithoutParameters(Constructor<?> constructor) {
        return constructor != null && !MemberUtils.isPrivate(constructor) && constructor.getParameterCount() < 1;
    }

    public static boolean hasNonPrivateConstructorWithoutParameters(Class<?> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        boolean has = false;
        for (Constructor<?> constructor : constructors) {
            if (!ConstructorUtils.isNonPrivateConstructorWithoutParameters(constructor)) continue;
            has = true;
            break;
        }
        return has;
    }

    @Nonnull
    @Immutable
    public static List<Constructor<?>> findConstructors(Class<?> type, Predicate<? super Constructor<?>> ... constructorFilters) {
        List<Constructor<?>> constructors = Lists.ofList(type.getConstructors());
        return Collections.unmodifiableList(Streams.filterAll(constructors, constructorFilters));
    }

    @Nonnull
    @Immutable
    public static List<Constructor<?>> findDeclaredConstructors(Class<?> type, Predicate<? super Constructor<?>> ... constructorFilters) {
        List<Constructor<?>> constructors = Lists.ofList(type.getDeclaredConstructors());
        return Collections.unmodifiableList(Streams.filterAll(constructors, constructorFilters));
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        return ThrowableSupplier.execute(() -> type.getConstructor(parameterTypes));
    }

    @Nullable
    public static <T> Constructor<T> getDeclaredConstructor(Class<T> type, Class<?> ... parameterTypes) {
        return ThrowableSupplier.execute(() -> type.getDeclaredConstructor(parameterTypes));
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<T> type, Class<?> ... parameterTypes) {
        return ThrowableSupplier.execute(() -> type.getDeclaredConstructor(parameterTypes), e -> {
            if (logger.isTraceEnabled()) {
                logger.trace("The declared constructor of '{}' can't be found by parameter types : {}", type, ArrayUtils.arrayToString(parameterTypes));
            }
            return NOT_FOUND_CONSTRUCTOR;
        });
    }

    @Nonnull
    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        AccessibleObjectUtils.trySetAccessible(constructor);
        return (T)ExecutableUtils.execute(constructor, () -> constructor.newInstance(args));
    }

    private ConstructorUtils() {
    }
}

