/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.lang.Deprecation;
import io.microsphere.reflect.MemberDefinition;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.Version;
import java.lang.reflect.Executable;
import java.util.Objects;

@Immutable
public abstract class ExecutableDefinition<E extends Executable>
extends MemberDefinition<E> {
    @Nonnull
    protected final String[] parameterClassNames;
    private transient boolean resolvedParameterTypes;
    @Nonnull
    private transient Class<?>[] parameterTypes;

    protected ExecutableDefinition(@Nonnull String since, @Nonnull String declaredClassName, @Nonnull String name, String ... parameterClassNames) {
        this(since, (Deprecation)null, declaredClassName, name, parameterClassNames);
    }

    protected ExecutableDefinition(@Nonnull String since, @Nonnull Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String name, String ... parameterClassNames) {
        this(Version.of(since), deprecation, declaredClassName, name, parameterClassNames);
    }

    protected ExecutableDefinition(@Nonnull Version since, @Nonnull String declaredClassName, @Nonnull String name, String ... parameterClassNames) {
        this(since, (Deprecation)null, declaredClassName, name, parameterClassNames);
    }

    protected ExecutableDefinition(@Nonnull Version since, @Nonnull Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String name, String ... parameterClassNames) {
        super(since, deprecation, declaredClassName, name);
        Assert.assertNotNull((Object)parameterClassNames, () -> "the class names of parameters of method must not be null.");
        Assert.assertNoNullElements((Object[])parameterClassNames, () -> "The parameter class names must not contain any null element.");
        this.parameterClassNames = parameterClassNames;
    }

    @Nonnull
    public final String[] getParameterClassNames() {
        return (String[])this.parameterClassNames.clone();
    }

    @Nonnull
    public final Class<?>[] getParameterTypes() {
        if (!this.resolvedParameterTypes && this.parameterTypes == null) {
            this.parameterTypes = this.resolveParameterTypes(this.parameterClassNames);
            this.resolvedParameterTypes = true;
        }
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExecutableDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecutableDefinition that = (ExecutableDefinition)o;
        return ArrayUtils.arrayEquals(this.parameterClassNames, that.parameterClassNames);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.parameterClassNames);
        return result;
    }

    protected Class<?>[] resolveParameterTypes(String[] parameterClassNames) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(this.getClass());
        int length = parameterClassNames.length;
        Class[] parameterTypes = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameterTypes[i] = ClassLoaderUtils.resolveClass(parameterClassNames[i], classLoader);
        }
        return parameterTypes;
    }
}

