/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.Deprecation;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.reflect.MemberDefinition;
import io.microsphere.util.Version;
import java.lang.reflect.Field;

@Immutable
public final class FieldDefinition
extends MemberDefinition<Field> {
    public FieldDefinition(@Nonnull String since, @Nonnull String declaredClassName, @Nonnull String fieldName) {
        super(since, declaredClassName, fieldName);
    }

    public FieldDefinition(@Nonnull String since, @Nullable Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String fieldName) {
        super(since, deprecation, declaredClassName, fieldName);
    }

    public FieldDefinition(@Nonnull Version since, @Nonnull String declaredClassName, @Nonnull String fieldName) {
        super(since, declaredClassName, fieldName);
    }

    public FieldDefinition(@Nonnull Version since, @Nullable Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String fieldName) {
        super(since, deprecation, declaredClassName, fieldName);
    }

    @Override
    protected Field resolveMember() {
        return FieldUtils.findField(this.getResolvedClass(), this.getFieldName());
    }

    @Nonnull
    public String getFieldName() {
        return super.getName();
    }

    @Nullable
    public Field getResolvedField() {
        return (Field)this.getMember();
    }

    public <T> T get(Object instance) throws IllegalStateException, IllegalArgumentException {
        return (T)FieldUtils.getFieldValue(instance, this.getResolvedField());
    }

    public <T> T set(Object instance, T fieldValue) {
        return FieldUtils.setFieldValue(instance, this.getResolvedField(), fieldValue);
    }
}

