/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ArrayUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Objects;

public class JavaType
implements Serializable {
    public static final JavaType[] EMPTY_JAVA_TYPE_ARRAY = new JavaType[0];
    public static final JavaType OBJECT_JAVA_TYPE = JavaType.from(Object.class, Kind.CLASS);
    public static final JavaType NULL_JAVA_TYPE = JavaType.from(null, Kind.UNKNOWN);
    private final Type type;
    private final transient Kind kind;
    private final JavaType source;
    private volatile JavaType superType;
    private volatile JavaType[] interfaces;
    private volatile JavaType[] genericTypes;

    protected JavaType(Type type) {
        this(type, Kind.valueOf(type));
    }

    protected JavaType(Type type, Kind kind) {
        this(type, kind, null);
    }

    protected JavaType(Type type, JavaType source) {
        this(type, Kind.valueOf(type), source);
    }

    protected JavaType(Type type, Kind kind, JavaType source) {
        this.type = type;
        this.kind = kind;
        this.source = source;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Nonnull
    public Kind getKind() {
        return this.kind;
    }

    @Nullable
    public JavaType getSource() {
        return this.source;
    }

    @Nullable
    public JavaType getRootSource() {
        JavaType rootSource;
        JavaType currentSource = this.source;
        if (currentSource == null) {
            return null;
        }
        while (true) {
            if ((rootSource = currentSource.source) == null) break;
            currentSource = currentSource.source;
        }
        rootSource = currentSource;
        return rootSource;
    }

    @Nullable
    public Type getRawType() {
        return this.kind.getRawType(this.type);
    }

    @Nullable
    public JavaType getSuperType() {
        JavaType superType = this.superType;
        if (superType == null) {
            this.superType = superType = this.resolveSuperType();
        }
        return superType;
    }

    protected JavaType resolveSuperType() {
        Type superType = JavaType.getSuperType(this.kind, this.type);
        return superType == null ? null : JavaType.from(superType, this);
    }

    @Nonnull
    public JavaType[] getInterfaces() {
        JavaType[] interfaces = this.interfaces;
        if (interfaces == null) {
            interfaces = this.resolveInterfaces();
            this.interfaces = interfaces;
        }
        return interfaces;
    }

    protected JavaType[] resolveInterfaces() {
        Type[] interfaces = this.kind.getInterfaces(this.type);
        return JavaType.from(interfaces, this);
    }

    @Nonnull
    public JavaType getInterface(int interfaceIndex) throws IndexOutOfBoundsException {
        return this.getInterfaces()[interfaceIndex];
    }

    @Nonnull
    public JavaType[] getGenericTypes() {
        JavaType[] genericTypes = this.genericTypes;
        if (genericTypes == null) {
            genericTypes = this.resolveGenericTypes();
            this.genericTypes = genericTypes;
        }
        return genericTypes;
    }

    @Nonnull
    protected JavaType[] resolveGenericTypes() {
        if (TypeUtils.isObjectType(this.type)) {
            return EMPTY_JAVA_TYPE_ARRAY;
        }
        Kind kind = this.kind;
        Type[] genericTypes = kind.getGenericTypes(this);
        return JavaType.from(genericTypes, this);
    }

    @Nonnull
    public JavaType getGenericType(int genericTypeIndex) throws IndexOutOfBoundsException {
        return this.getGenericTypes()[genericTypeIndex];
    }

    @Nullable
    public JavaType as(Class<?> targetClass) {
        if (TypeUtils.isObjectClass(targetClass)) {
            return JavaType.from(Object.class, Kind.CLASS, this);
        }
        Type typeToMatch = this.type;
        Type targetType = JavaType.searchSuperType(targetClass, typeToMatch);
        if (targetType == null) {
            targetType = JavaType.searchInterfaceType(targetClass, typeToMatch);
        }
        return targetType == null ? null : JavaType.from(targetType, this);
    }

    @Nullable
    public <T> Class<T> toClass() {
        Type rawType = this.getRawType();
        return rawType == null ? null : (Class)rawType;
    }

    @Nullable
    public ParameterizedType toParameterizedType() {
        return TypeUtils.asParameterizedType(this.type);
    }

    @Nullable
    public TypeVariable toTypeVariable() {
        return TypeUtils.asTypeVariable(this.type);
    }

    @Nullable
    public WildcardType toWildcardType() {
        return TypeUtils.asWildcardType(this.type);
    }

    @Nullable
    public GenericArrayType toGenericArrayType() {
        return TypeUtils.asGenericArrayType(this.type);
    }

    public boolean isSource() {
        return this.source == null;
    }

    public boolean isRootSource() {
        return this.getRootSource() == null;
    }

    public boolean isClass() {
        return Kind.CLASS.equals((Object)this.kind);
    }

    public boolean isParameterizedType() {
        return Kind.PARAMETERIZED_TYPE.equals((Object)this.kind);
    }

    public boolean isTypeVariable() {
        return Kind.TYPE_VARIABLE.equals((Object)this.kind);
    }

    public boolean isWildCardType() {
        return Kind.WILDCARD_TYPE.equals((Object)this.kind);
    }

    public boolean isGenericArrayType() {
        return Kind.GENERIC_ARRAY_TYPE.equals((Object)this.kind);
    }

    public boolean isUnknownType() {
        return Kind.UNKNOWN.equals((Object)this.kind);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaType)) {
            return false;
        }
        JavaType javaType = (JavaType)o;
        return Objects.equals(this.type, javaType.type) && this.kind == javaType.kind && Objects.equals(this.source, javaType.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.kind, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JavaType{");
        sb.append("type=").append(this.type);
        sb.append(", kind=").append((Object)this.kind);
        sb.append(", source=").append(this.source);
        sb.append('}');
        return sb.toString();
    }

    @Nullable
    public static JavaType fromField(Class<?> declaredClass, String fieldName) {
        Field field = FieldUtils.findField(declaredClass, fieldName);
        return JavaType.fromField(field);
    }

    @Nonnull
    public static JavaType fromField(Field field) {
        return field == null ? NULL_JAVA_TYPE : JavaType.from(field.getGenericType());
    }

    @Nonnull
    public static JavaType fromMethodReturnType(Class<?> declaredClass, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.findMethod(declaredClass, methodName, parameterTypes);
        return JavaType.fromMethodReturnType(method);
    }

    @Nonnull
    public static JavaType fromMethodReturnType(Method method) {
        return method == null ? NULL_JAVA_TYPE : JavaType.from(method.getGenericReturnType());
    }

    @Nonnull
    public static JavaType[] fromMethodParameters(Class<?> declaredClass, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.findMethod(declaredClass, methodName, parameterTypes);
        return method == null ? EMPTY_JAVA_TYPE_ARRAY : JavaType.fromMethodParameters(method);
    }

    @Nonnull
    public static JavaType[] fromMethodParameters(Method method) {
        Type[] genericParameterType = method.getGenericParameterTypes();
        return JavaType.from(genericParameterType);
    }

    @Nonnull
    public static JavaType fromMethodParameter(Method method, int parameterIndex) {
        Type genericParameterType = method.getGenericParameterTypes()[parameterIndex];
        return JavaType.from(genericParameterType);
    }

    @Nonnull
    public static JavaType from(Class<?> targetClass) {
        return JavaType.from(targetClass, Kind.CLASS);
    }

    @Nonnull
    public static JavaType from(Type type) {
        return new JavaType(type);
    }

    @Nonnull
    protected static JavaType from(Type type, Kind kind) {
        return new JavaType(type, kind);
    }

    @Nonnull
    protected static JavaType from(Type type, JavaType source) {
        return new JavaType(type, source);
    }

    @Nonnull
    protected static JavaType from(Type type, Kind kind, JavaType source) {
        return new JavaType(type, kind, source);
    }

    @Nonnull
    protected static JavaType[] from(Type[] types) {
        return JavaType.from(types, null);
    }

    @Nonnull
    protected static JavaType[] from(Type[] types, JavaType source) {
        int length = ArrayUtils.length(types);
        if (length == 0) {
            return EMPTY_JAVA_TYPE_ARRAY;
        }
        JavaType[] javaTypes = new JavaType[length];
        for (int i = 0; i < length; ++i) {
            javaTypes[i] = JavaType.from(types[i], source);
        }
        return javaTypes;
    }

    static Type searchSuperType(Class<?> targetClass, Type typeToMatch) {
        Type superType = JavaType.getSuperType(typeToMatch);
        if (superType == null) {
            return null;
        }
        Type targetType = null;
        while (!JavaType.matches(Object.class, superType)) {
            if (JavaType.matches(targetClass, superType)) {
                targetType = superType;
                break;
            }
            targetType = JavaType.searchInterfaceType(targetClass, superType);
            if (targetType != null) break;
            superType = JavaType.getSuperType(superType);
        }
        return targetType;
    }

    static Type searchInterfaceType(Class<?> targetClass, Type typeToMatch) {
        Type[] interfaces;
        Type targetType = null;
        for (Type interfaceType : interfaces = JavaType.getInterfaces(typeToMatch)) {
            if (JavaType.matches(targetClass, interfaceType)) {
                targetType = interfaceType;
                break;
            }
            targetType = JavaType.searchInterfaceType(targetClass, interfaceType);
            if (targetType != null) break;
        }
        return targetType;
    }

    static Type getSuperType(Type type) {
        return JavaType.getSuperType(Kind.valueOf(type), type);
    }

    static Type getSuperType(Kind kind, Type type) {
        return kind.getSuperType(type);
    }

    static Type[] getInterfaces(Type type) {
        Kind kind = Kind.valueOf(type);
        return kind.getInterfaces(type);
    }

    private static boolean matches(Class<?> targetClass, Type typeToMatch) {
        Kind kind = Kind.valueOf(typeToMatch);
        Type rawType = kind.getRawType(typeToMatch);
        return Objects.equals(targetClass, rawType);
    }

    public static enum Kind {
        CLASS(Class.class){

            @Override
            public Type getSuperType(Type type) {
                Class<?> klass = this.as(type);
                return klass.getGenericSuperclass();
            }

            @Override
            public Type getRawType(Type type) {
                return type;
            }

            @Override
            public Type[] getInterfaces(Type type) {
                Class<?> klass = this.as(type);
                return klass.getGenericInterfaces();
            }

            @Override
            public Type[] getGenericTypes(JavaType javaType) {
                Class<?> klass = this.as(javaType.type);
                TypeVariable<Class<?>>[] typeParameters = klass.getTypeParameters();
                int length = typeParameters.length;
                return length == 0 ? super.getGenericTypes(javaType) : new Type[length];
            }

            private Class<?> as(Type type) {
                return TypeUtils.getRawClass(type);
            }
        }
        ,
        PARAMETERIZED_TYPE(ParameterizedType.class){

            @Override
            public Type getSuperType(Type type) {
                Type rawType = this.getRawType(type);
                Kind rawTypeKind = 2.valueOf(rawType);
                return rawTypeKind.getSuperType(rawType);
            }

            @Override
            public Type getRawType(Type type) {
                ParameterizedType pType = this.as(type);
                Type rawType = pType.getRawType();
                return rawType;
            }

            @Override
            public Type[] getInterfaces(Type type) {
                Type rawType = this.getRawType(type);
                Kind rawTypeKind = 2.valueOf(rawType);
                return rawTypeKind.getInterfaces(rawType);
            }

            @Override
            public Type[] getGenericTypes(JavaType javaType) {
                Type[] genericTypes;
                Type baseType;
                Type type = this.resolveType(javaType);
                List<Type> genericTypesList = TypeUtils.resolveActualTypeArguments(type, baseType = javaType.type);
                if (genericTypesList.isEmpty()) {
                    genericTypes = this.as(baseType).getActualTypeArguments();
                    this.toActualTypes(genericTypes);
                } else {
                    genericTypes = ArrayUtils.asArray(genericTypesList, Type.class);
                }
                return genericTypes;
            }

            private void toActualTypes(Type[] genericTypes) {
                for (Type genericType : genericTypes) {
                    if (TypeUtils.isActualType(genericType)) continue;
                    genericTypes[i] = null;
                }
            }

            private Type resolveType(JavaType javaType) {
                JavaType source = javaType.getRootSource();
                if (source == null) {
                    source = javaType.getSource();
                }
                return source == null ? javaType.type : source.type;
            }

            private ParameterizedType as(Type type) {
                return (ParameterizedType)type;
            }
        }
        ,
        TYPE_VARIABLE(TypeVariable.class),
        WILDCARD_TYPE(WildcardType.class),
        GENERIC_ARRAY_TYPE(GenericArrayType.class),
        UNKNOWN(Type.class);

        final Class<? extends Type> typeClass;

        private Kind(Class<? extends Type> typeClass) {
            this.typeClass = typeClass;
        }

        public Type getRawType(Type type) {
            return null;
        }

        public Type getSuperType(Type type) {
            return null;
        }

        public Type[] getInterfaces(Type type) {
            return ArrayUtils.EMPTY_TYPE_ARRAY;
        }

        public Type[] getGenericTypes(JavaType javaType) {
            return ArrayUtils.EMPTY_TYPE_ARRAY;
        }

        public static Kind valueOf(Type type) {
            Kind kind = UNKNOWN;
            for (Kind e : Kind.values()) {
                if (!e.typeClass.isInstance(type)) continue;
                kind = e;
                break;
            }
            return kind;
        }
    }
}

