/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.Deprecation;
import io.microsphere.reflect.ReflectiveDefinition;
import io.microsphere.util.Version;
import java.lang.reflect.Member;

@Immutable
public abstract class MemberDefinition<M extends Member>
extends ReflectiveDefinition {
    @Nonnull
    protected final String name;
    @Nullable
    private transient M member;
    private boolean resolvedMember;

    protected MemberDefinition(@Nonnull String since, @Nonnull String declaredClassName, @Nonnull String name) {
        this(since, null, declaredClassName, name);
    }

    protected MemberDefinition(@Nonnull String since, @Nullable Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String name) {
        this(Version.ofVersion(since), deprecation, declaredClassName, name);
    }

    protected MemberDefinition(@Nonnull Version since, @Nonnull String declaredClassName, @Nonnull String name) {
        this(since, null, declaredClassName, name);
    }

    protected MemberDefinition(@Nonnull Version since, @Nullable Deprecation deprecation, @Nonnull String declaredClassName, @Nonnull String name) {
        super(since, deprecation, declaredClassName);
        this.name = name;
    }

    protected abstract M resolveMember();

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nonnull
    public final String getDeclaredClassName() {
        return super.getClassName();
    }

    @Nullable
    public final Class<?> getDeclaredClass() {
        return super.getResolvedClass();
    }

    @Nullable
    public final M getMember() {
        if (!this.resolvedMember && this.member == null) {
            this.member = this.resolveMember();
            this.resolvedMember = true;
        }
        return this.member;
    }

    @Override
    public boolean isPresent() {
        return this.getMember() != null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MemberDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemberDefinition that = (MemberDefinition)o;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

