/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.util.Utils;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public abstract class MemberUtils
implements Utils {
    public static final Predicate<? super Member> STATIC_MEMBER_PREDICATE = MemberUtils::isStatic;
    public static final Predicate<? super Member> NON_STATIC_MEMBER_PREDICATE = MemberUtils::isNonStatic;
    public static final Predicate<? super Member> FINAL_MEMBER_PREDICATE = MemberUtils::isFinal;
    public static final Predicate<? super Member> PUBLIC_MEMBER_PREDICATE = MemberUtils::isPublic;
    public static final Predicate<? super Member> NON_PRIVATE_MEMBER_PREDICATE = MemberUtils::isNonPrivate;

    public static boolean isStatic(Member member) {
        return member != null && Modifier.isStatic(member.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return member != null && Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isNonStatic(Member member) {
        return member != null && !Modifier.isStatic(member.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return member != null && Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return member != null && Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers());
    }

    public static boolean isNonPrivate(Member member) {
        return member != null && !Modifier.isPrivate(member.getModifiers());
    }

    public static Member asMember(Object object) {
        return object instanceof Member ? (Member)object : null;
    }

    private MemberUtils() {
    }
}

