/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

public enum Modifier {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    STATIC(8),
    FINAL(16),
    SYNCHRONIZED(32),
    VOLATILE(64),
    TRANSIENT(128),
    NATIVE(256),
    INTERFACE(512),
    ABSTRACT(1024),
    STRICT(2048),
    BRIDGE(64),
    VARARGS(128),
    SYNTHETIC(4096),
    ANNOTATION(8192),
    ENUM(16384),
    MANDATED(32768);

    private final int value;

    private Modifier(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean matches(int mod) {
        return (mod & this.value) != 0;
    }

    public static boolean isPublic(int modifiers) {
        return PUBLIC.matches(modifiers);
    }

    public static boolean isPrivate(int modifiers) {
        return PRIVATE.matches(modifiers);
    }

    public static boolean isProtected(int modifiers) {
        return PROTECTED.matches(modifiers);
    }

    public static boolean isStatic(int modifiers) {
        return STATIC.matches(modifiers);
    }

    public static boolean isFinal(int modifiers) {
        return FINAL.matches(modifiers);
    }

    public static boolean isSynchronized(int modifiers) {
        return SYNCHRONIZED.matches(modifiers);
    }

    public static boolean isVolatile(int modifiers) {
        return VOLATILE.matches(modifiers);
    }

    public static boolean isTransient(int modifiers) {
        return TRANSIENT.matches(modifiers);
    }

    public static boolean isNative(int modifiers) {
        return NATIVE.matches(modifiers);
    }

    public static boolean isInterface(int modifiers) {
        return INTERFACE.matches(modifiers);
    }

    public static boolean isAbstract(int modifiers) {
        return ABSTRACT.matches(modifiers);
    }

    public static boolean isStrict(int modifiers) {
        return STRICT.matches(modifiers);
    }

    public static boolean isBridge(int modifiers) {
        return BRIDGE.matches(modifiers);
    }

    public static boolean isVarArgs(int modifiers) {
        return VARARGS.matches(modifiers);
    }

    public static boolean isSynthetic(int modifiers) {
        return SYNTHETIC.matches(modifiers);
    }

    public static boolean isAnnotation(int modifiers) {
        return ANNOTATION.matches(modifiers);
    }

    public static boolean isEnum(int modifiers) {
        return ENUM.matches(modifiers);
    }

    public static boolean isMandated(int modifiers) {
        return MANDATED.matches(modifiers);
    }
}

