/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.reflect.ConstructorUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public abstract class ProxyUtils
implements Utils {
    public static boolean isProxyable(Class<?> type) {
        if (ClassUtils.isArray(type)) {
            return false;
        }
        if (ClassUtils.isPrimitive(type)) {
            return false;
        }
        if (Modifier.isFinal(type.getModifiers())) {
            return false;
        }
        if (!ConstructorUtils.hasNonPrivateConstructorWithoutParameters(type)) {
            return false;
        }
        List<Method> methods = MethodUtils.findAllDeclaredMethods(type, MethodUtils.NON_STATIC_METHOD_PREDICATE, MethodUtils.FINAL_METHOD_PREDICATE, MethodUtils.NON_PRIVATE_METHOD_PREDICATE, MethodUtils.OBJECT_METHOD_PREDICATE.negate());
        return methods.isEmpty();
    }

    private ProxyUtils() {
    }
}

