/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.AccessibleObjectUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ReflectionUtils
implements Utils {
    private static final Class<?> TYPE;
    private static final Logger logger;
    public static final String SUN_REFLECT_REFLECTION_CLASS_NAME = "sun.reflect.Reflection";
    private static final String getCallerClassMethodName = "getCallerClass";
    private static final int sunReflectReflectionInvocationFrame;
    private static final int stackTraceElementInvocationFrame;
    private static final boolean supportedSunReflectReflection;
    private static final Method getCallerClassMethod;
    public static final String INACCESSIBLE_OBJECT_EXCEPTION_CLASS_NAME = "java.lang.reflect.InaccessibleObjectException";
    @Nullable
    public static final Class<? extends Throwable> INACCESSIBLE_OBJECT_EXCEPTION_CLASS;

    public static boolean isSupportedSunReflectReflection() {
        return supportedSunReflectReflection;
    }

    @Nonnull
    public static String getCallerClassName() {
        Class<?> callerClass;
        if (supportedSunReflectReflection && (callerClass = ReflectionUtils.getCallerClassInSunJVM(sunReflectReflectionInvocationFrame)) != null) {
            return callerClass.getName();
        }
        return ReflectionUtils.getCallerClassNameInGeneralJVM(stackTraceElementInvocationFrame);
    }

    static String getCallerClassNameInGeneralJVM() {
        return ReflectionUtils.getCallerClassNameInGeneralJVM(stackTraceElementInvocationFrame);
    }

    static String getCallerClassNameInGeneralJVM(int invocationFrame) throws IndexOutOfBoundsException {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (invocationFrame < elements.length) {
            StackTraceElement targetStackTraceElement = elements[invocationFrame];
            return targetStackTraceElement.getClassName();
        }
        return null;
    }

    static Class<?> getCallerClassInSunJVM(int realFramesToSkip) throws UnsupportedOperationException {
        if (!supportedSunReflectReflection) {
            throw new UnsupportedOperationException("Requires SUN's JVM!");
        }
        Class callerClass = null;
        if (getCallerClassMethod != null) {
            try {
                callerClass = (Class)getCallerClassMethod.invoke(null, realFramesToSkip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return callerClass;
    }

    static Class<?> getCallerClassInGeneralJVM(int invocationFrame) {
        String className = ReflectionUtils.getCallerClassNameInGeneralJVM(invocationFrame + 1);
        Class<?> targetClass = null;
        try {
            targetClass = className == null ? null : Class.forName(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return targetClass;
    }

    @Nonnull
    public static Class<?> getCallerClass() throws IllegalStateException {
        Class<?> callerClass;
        if (supportedSunReflectReflection && (callerClass = ReflectionUtils.getCallerClassInSunJVM(sunReflectReflectionInvocationFrame)) != null) {
            return callerClass;
        }
        return ReflectionUtils.getCallerClassInGeneralJVM(stackTraceElementInvocationFrame);
    }

    static Class<?> getCallerClassInSunJVM() throws UnsupportedOperationException {
        return ReflectionUtils.getCallerClassInSunJVM(sunReflectReflectionInvocationFrame);
    }

    static String getCallerClassNameInSunJVM() throws UnsupportedOperationException {
        Class<?> callerClass = ReflectionUtils.getCallerClassInSunJVM(sunReflectReflectionInvocationFrame);
        return callerClass.getName();
    }

    public static Class<?> getCallerClass(int invocationFrame) {
        Class<?> callerClass;
        if (supportedSunReflectReflection && (callerClass = ReflectionUtils.getCallerClassInSunJVM(invocationFrame + 1)) != null) {
            return callerClass;
        }
        return ReflectionUtils.getCallerClassInGeneralJVM(invocationFrame + 1);
    }

    static Class<?> getCallerClassInGeneralJVM() {
        return ReflectionUtils.getCallerClassInGeneralJVM(stackTraceElementInvocationFrame);
    }

    @Nonnull
    public static <T> List<T> toList(Object array) throws IllegalArgumentException {
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            list.add(ReflectionUtils.toObject(element));
        }
        return list;
    }

    private static Object toObject(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return ReflectionUtils.toList(object);
        }
        return object;
    }

    @Nonnull
    @Immutable
    public static Map<String, Object> readFieldsAsMap(Object object) {
        Field[] fields;
        LinkedHashMap<String, Map<String, Object>> fieldsAsMap = new LinkedHashMap<String, Map<String, Object>>();
        Class<?> type = object.getClass();
        for (Field field : fields = type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            AccessibleObjectUtils.trySetAccessible(field);
            try {
                String fieldName = field.getName();
                Map<String, Object> fieldValue = field.get(object);
                if (fieldValue == null || fieldValue == object) continue;
                Class<?> fieldValueType = fieldValue.getClass();
                if (!(ClassUtils.isPrimitive(fieldValueType) || ClassUtils.isSimpleType(fieldValueType) || Objects.equals(object.getClass(), fieldValueType))) {
                    fieldValue = ReflectionUtils.readFieldsAsMap(fieldValue);
                }
                fieldsAsMap.put(fieldName, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.unmodifiableMap(fieldsAsMap);
    }

    public static boolean isInaccessibleObjectException(Throwable failure) {
        return failure != null && INACCESSIBLE_OBJECT_EXCEPTION_CLASS_NAME.equals(failure.getClass().getName());
    }

    private ReflectionUtils() {
    }

    static {
        StackTraceElement[] stackTraceElements;
        int invocationFrame;
        boolean supported;
        Method method;
        block4: {
            TYPE = ReflectionUtils.class;
            logger = LoggerFactory.getLogger(TYPE);
            INACCESSIBLE_OBJECT_EXCEPTION_CLASS = ClassLoaderUtils.resolveClass(INACCESSIBLE_OBJECT_EXCEPTION_CLASS_NAME);
            method = null;
            supported = false;
            invocationFrame = 0;
            try {
                Class<?> type = Class.forName(SUN_REFLECT_REFLECTION_CLASS_NAME);
                method = type.getMethod(getCallerClassMethodName, Integer.TYPE);
                method.setAccessible(true);
                for (int i = 0; i < 9; ++i) {
                    Class callerClass = (Class)method.invoke(null, i);
                    if (!TYPE.equals(callerClass)) continue;
                    invocationFrame = i;
                    break;
                }
                supported = true;
            }
            catch (Throwable e) {
                if (!logger.isTraceEnabled()) break block4;
                logger.trace("The class '{}' or its' method '{}({})' can't be initialized.", SUN_REFLECT_REFLECTION_CLASS_NAME, getCallerClassMethodName, Integer.TYPE, e);
            }
        }
        getCallerClassMethod = method;
        supportedSunReflectReflection = supported;
        sunReflectReflectionInvocationFrame = invocationFrame + 2;
        int invocationFrame2 = 0;
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (TYPE.getName().equals(className)) break;
            ++invocationFrame2;
        }
        stackTraceElementInvocationFrame = invocationFrame2 + 2;
    }
}

