/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect.generics;

import io.microsphere.util.Assert;
import java.lang.reflect.Type;
import java.util.Objects;

public class TypeArgument {
    private final Type type;
    private final int index;

    protected TypeArgument(Type type, int index) {
        Assert.assertNotNull((Object)type, () -> "The 'type' must not be null");
        Assert.assertTrue(index > -1, () -> "The 'index' must not be positive");
        this.type = type;
        this.index = index;
    }

    public String toString() {
        return "TypeArgument{type=" + this.type + ", index=" + this.index + '}';
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgument that = (TypeArgument)o;
        if (this.index != that.index) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.index;
        return result;
    }

    public static TypeArgument create(Type type, int index) {
        return new TypeArgument(type, index);
    }
}

