/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.CharSequenceUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public abstract class Assert {
    public static void assertTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNull(@Nullable Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotNull(@Nullable Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotEmpty(@Nullable String text, String message) {
        if (CharSequenceUtils.isEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(@Nullable String text, Supplier<String> messageSupplier) {
        if (CharSequenceUtils.isEmpty(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotBlank(@Nullable String text, String message) {
        if (StringUtils.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotBlank(@Nullable String text, Supplier<String> messageSupplier) {
        if (StringUtils.isBlank(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotEmpty(@Nullable Object[] array, String message) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (ArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotEmpty(@Nullable Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotEmpty(@Nullable Map<?, ?> map, String message) {
        if (MapUtils.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(@Nullable Map<?, ?> map, Supplier<String> messageSupplier) {
        if (MapUtils.isEmpty(map)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNoNullElements(@Nullable Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void assertNoNullElements(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void assertNoNullElements(@Nullable Iterable<?> elements, String message) {
        if (elements != null) {
            for (Object element : elements) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void assertNoNullElements(@Nullable Iterable<?> elements, Supplier<String> messageSupplier) {
        if (elements != null) {
            for (Object element : elements) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void assertArrayIndex(Object array, int index) throws IllegalArgumentException {
        if (index < 0) {
            String message = FormatUtils.format("The index argument must be positive , actual is {}", index);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Assert.assertArrayType(array);
        int length = Array.getLength(array);
        if (index > length - 1) {
            String message = FormatUtils.format("The index must be less than {} , actual is {}", length, index);
            throw new ArrayIndexOutOfBoundsException(message);
        }
    }

    public static void assertArrayType(Object array) throws IllegalArgumentException {
        Class<?> type = array.getClass();
        if (!ClassUtils.isArray(type)) {
            String message = FormatUtils.format("The argument is not an array object, its type is {}", type.getName());
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertFieldMatchType(Object object, String fieldName, Class<?> expectedType) throws NullPointerException, IllegalArgumentException {
        Class<?> type = object.getClass();
        Field field = FieldUtils.findField(type, fieldName);
        Class<?> fieldType = field.getType();
        if (!ClassUtils.isAssignableFrom(expectedType, fieldType)) {
            String message = FormatUtils.format("The type['{}'] of field[name : '{}'] in Class['{}'] can't match expected type['{}']", ClassUtils.getTypeName(fieldType), fieldName, ClassUtils.getTypeName(type), ClassUtils.getTypeName(expectedType));
            throw new IllegalArgumentException(message);
        }
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier == null ? null : messageSupplier.get();
    }
}

