/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nullable;
import io.microsphere.util.Utils;

public abstract class CharSequenceUtils
implements Utils {
    public static int length(@Nullable CharSequence value) {
        return value == null ? 0 : value.length();
    }

    public static boolean isEmpty(@Nullable CharSequence value) {
        return CharSequenceUtils.length(value) == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence value) {
        return CharSequenceUtils.length(value) > 0;
    }

    public static boolean containsWhitespace(@Nullable CharSequence str) {
        int strLen = CharSequenceUtils.length(str);
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static CharSequence trimAllWhitespace(CharSequence str) {
        int len = CharSequenceUtils.length(str);
        if (len < 1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb;
    }

    private CharSequenceUtils() {
    }
}

