/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.classloading.ServiceLoadingURLClassPathHandle;
import io.microsphere.classloading.URLClassPathHandle;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.io.IOUtils;
import io.microsphere.lang.ClassDataRepository;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.management.JmxUtils;
import io.microsphere.net.URLUtils;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.reflect.ReflectionUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.SystemUtils;
import io.microsphere.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ClassLoaderUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static final Class<ClassLoader> classLoaderClass = ClassLoader.class;
    private static final String findLoadedClassMethodName = "findLoadedClass";
    private static final String classesFieldName = "classes";
    protected static final ClassLoadingMXBean classLoadingMXBean = JmxUtils.getClassLoadingMXBean();
    private static final ConcurrentMap<String, Class<?>> loadedClassesCache = new ConcurrentHashMap(256);
    private static final URLClassPathHandle urlClassPathHandle = new ServiceLoadingURLClassPathHandle();

    public static int getLoadedClassCount() {
        return classLoadingMXBean.getLoadedClassCount();
    }

    public static long getUnloadedClassCount() {
        return classLoadingMXBean.getUnloadedClassCount();
    }

    public static long getTotalLoadedClassCount() {
        return classLoadingMXBean.getTotalLoadedClassCount();
    }

    public static boolean isVerbose() {
        return classLoadingMXBean.isVerbose();
    }

    public static void setVerbose(boolean value) {
        classLoadingMXBean.setVerbose(value);
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classLoader;
    }

    @Nullable
    public static ClassLoader getClassLoader(@Nullable Class<?> loadedClass) {
        ClassLoader classLoader = null;
        try {
            classLoader = loadedClass == null ? ClassLoaderUtils.getCallerClassLoader(4) : loadedClass.getClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
    }

    @Nullable
    public static ClassLoader getCallerClassLoader() {
        return ClassLoaderUtils.getCallerClassLoader(4);
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> findLoadedClasses(@Nullable ClassLoader classLoader, String ... classNames) {
        return ClassLoaderUtils.findLoadedClasses(classLoader, SetUtils.ofSet(classNames));
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> findLoadedClasses(@Nullable ClassLoader classLoader, Iterable<String> classNames) {
        int size = CollectionUtils.size(classNames);
        if (size < 1) {
            return Collections.emptySet();
        }
        Set<Class<?>> loadedClasses = SetUtils.newLinkedHashSet(size);
        for (String className : classNames) {
            Class<?> class_ = ClassLoaderUtils.findLoadedClass(classLoader, className);
            if (class_ == null) continue;
            loadedClasses.add(class_);
        }
        return Collections.unmodifiableSet(loadedClasses);
    }

    public static boolean isLoadedClass(@Nullable ClassLoader classLoader, Class<?> type) {
        return ClassLoaderUtils.isLoadedClass(classLoader, type.getName());
    }

    public static boolean isLoadedClass(@Nullable ClassLoader classLoader, String className) {
        return ClassLoaderUtils.findLoadedClass(classLoader, className) != null;
    }

    @Nullable
    public static Class<?> findLoadedClass(@Nullable ClassLoader classLoader, String className) {
        Class<?> loadedClass;
        block1: {
            ClassLoader loader;
            ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
            loadedClass = ClassLoaderUtils.invokeFindLoadedClassMethod(actualClassLoader, className);
            if (loadedClass != null) break block1;
            Set<ClassLoader> classLoaders = ClassLoaderUtils.doGetInheritableClassLoaders(actualClassLoader);
            Iterator<ClassLoader> iterator = classLoaders.iterator();
            while (iterator.hasNext() && (loadedClass = ClassLoaderUtils.invokeFindLoadedClassMethod(loader = iterator.next(), className)) == null) {
            }
        }
        return loadedClass;
    }

    @Nullable
    public static Class<?> loadClass(@Nullable ClassLoader classLoader, @Nullable String className) {
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        return ClassLoaderUtils.doLoadClass(actualClassLoader, className);
    }

    @Nullable
    public static Class<?> loadClass(@Nullable ClassLoader classLoader, @Nullable String className, boolean cached) {
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        if (cached) {
            String cacheKey = ClassLoaderUtils.buildCacheKey(actualClassLoader, className);
            return loadedClassesCache.computeIfAbsent(cacheKey, k -> ClassLoaderUtils.doLoadClass(actualClassLoader, className));
        }
        return ClassLoaderUtils.doLoadClass(actualClassLoader, className);
    }

    protected static Class<?> doLoadClass(ClassLoader classLoader, String className) {
        if (StringUtils.isBlank(className)) {
            return null;
        }
        Class<?> klass = null;
        try {
            klass = classLoader.loadClass(className);
        }
        catch (Throwable e) {
            if (logger.isTraceEnabled()) {
                logger.trace("The Class[name : '{}'] can't be loaded from the ClassLoader : {}", className, classLoader, e);
            }
            klass = ClassUtils.resolvePrimitiveClassForName(className);
        }
        return klass;
    }

    @Nonnull
    @Immutable
    public static Set<URL> getResources(@Nullable ClassLoader classLoader, @Nonnull ResourceType resourceType, String resourceName) throws NullPointerException, IOException {
        String normalizedResourceName;
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        Enumeration<URL> resources = actualClassLoader.getResources(normalizedResourceName = resourceType.resolve(resourceName));
        return resources != null && resources.hasMoreElements() ? SetUtils.ofSet(resources) : Collections.emptySet();
    }

    @Nonnull
    @Immutable
    public static Set<URL> getResources(@Nullable ClassLoader classLoader, String resourceName) throws NullPointerException, IOException {
        ResourceType resourceType;
        Set<URL> resourceURLs = Collections.emptySet();
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        for (int i = 0; i < n && !CollectionUtils.isNotEmpty(resourceURLs = ClassLoaderUtils.getResources(classLoader, resourceType = resourceTypeArray[i], resourceName)); ++i) {
        }
        return resourceURLs;
    }

    @Nullable
    public static URL getResource(String resourceName) throws NullPointerException {
        return ClassLoaderUtils.getResource(null, resourceName);
    }

    @Nullable
    public static URL getResource(@Nullable ClassLoader classLoader, String resourceName) throws NullPointerException {
        ResourceType resourceType;
        URL resourceURL = null;
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        for (int i = 0; i < n && (resourceURL = ClassLoaderUtils.getResource(classLoader, resourceType = resourceTypeArray[i], resourceName)) == null; ++i) {
        }
        return resourceURL;
    }

    @Nullable
    public static URL getResource(@Nullable ClassLoader classLoader, ResourceType resourceType, String resourceName) throws NullPointerException {
        URL resource;
        String normalizedResourceName = resourceType.resolve(resourceName);
        URL uRL = resource = normalizedResourceName == null ? null : ClassLoaderUtils.findClassLoader(classLoader).getResource(normalizedResourceName);
        if (logger.isTraceEnabled()) {
            logger.trace("To find the resource[name : '{}' , normalized : '{}' , type = {} , ClassLoader : {}] : {}", new Object[]{resourceName, normalizedResourceName, resourceType, classLoader, resource});
        }
        return resource;
    }

    @Nullable
    public static String getResourceAsString(String resourceName) throws NullPointerException, IOException {
        return ClassLoaderUtils.getResourceAsString(null, resourceName);
    }

    @Nullable
    public static String getResourceAsString(@Nullable ClassLoader classLoader, String resourceName) throws NullPointerException, IOException {
        String content;
        URL resource = ClassLoaderUtils.getResource(classLoader, resourceName);
        if (resource == null) {
            return null;
        }
        try (InputStream inputStream = resource.openStream();){
            content = IOUtils.copyToString(inputStream);
        }
        return content;
    }

    public static URL getClassResource(@Nullable ClassLoader classLoader, String className) {
        String resourceName = className + ".class";
        return ClassLoaderUtils.getResource(classLoader, ResourceType.CLASS, resourceName);
    }

    @Nullable
    public static URL getClassResource(Class<?> type) {
        return ClassLoaderUtils.getClassResource(ClassLoaderUtils.getClassLoader(type), type);
    }

    @Nullable
    public static URL getClassResource(@Nullable ClassLoader classLoader, Class<?> type) {
        String resourceName = type.getName();
        return ClassLoaderUtils.getClassResource(classLoader, resourceName);
    }

    @Nonnull
    @Immutable
    public static Set<ClassLoader> getInheritableClassLoaders(@Nullable ClassLoader classLoader) throws NullPointerException {
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        return Collections.unmodifiableSet(ClassLoaderUtils.doGetInheritableClassLoaders(actualClassLoader));
    }

    @Nonnull
    static Set<ClassLoader> doGetInheritableClassLoaders(ClassLoader classLoader) throws NullPointerException {
        Set<ClassLoader> classLoadersSet = SetUtils.newLinkedHashSet();
        classLoadersSet.add(classLoader);
        for (ClassLoader parentClassLoader = classLoader.getParent(); parentClassLoader != null; parentClassLoader = parentClassLoader.getParent()) {
            classLoadersSet.add(parentClassLoader);
        }
        return classLoadersSet;
    }

    @Nonnull
    @Immutable
    public static Map<ClassLoader, Set<Class<?>>> getAllLoadedClassesMap(@Nullable ClassLoader classLoader) throws UnsupportedOperationException {
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        LinkedHashMap allLoadedClassesMap = new LinkedHashMap();
        Set<ClassLoader> classLoadersSet = ClassLoaderUtils.doGetInheritableClassLoaders(actualClassLoader);
        for (ClassLoader loader : classLoadersSet) {
            allLoadedClassesMap.put(loader, ClassLoaderUtils.getLoadedClasses(actualClassLoader));
        }
        return Collections.unmodifiableMap(allLoadedClassesMap);
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> getAllLoadedClasses(@Nullable ClassLoader classLoader) throws UnsupportedOperationException {
        Set<Class<?>> allLoadedClassesSet = SetUtils.newLinkedHashSet();
        Map<ClassLoader, Set<Class<?>>> allLoadedClassesMap = ClassLoaderUtils.getAllLoadedClassesMap(classLoader);
        for (Set<Class<?>> loadedClassesSet : allLoadedClassesMap.values()) {
            allLoadedClassesSet.addAll(loadedClassesSet);
        }
        return Collections.unmodifiableSet(allLoadedClassesSet);
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> getLoadedClasses(@Nullable ClassLoader classLoader) throws UnsupportedOperationException {
        Field field;
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        List classes = (List)FieldUtils.getFieldValue((Object)actualClassLoader, field = FieldUtils.findField(classLoaderClass, classesFieldName));
        return classes == null ? Collections.emptySet() : SetUtils.ofSet(classes);
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> findLoadedClassesInClassPath(@Nullable ClassLoader classLoader) throws UnsupportedOperationException {
        Set<String> classNames = ClassDataRepository.INSTANCE.getAllClassNamesInClassPaths();
        return ClassLoaderUtils.findLoadedClasses(classLoader, classNames);
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> findLoadedClassesInClassPaths(@Nullable ClassLoader classLoader, Set<String> classPaths) throws UnsupportedOperationException {
        Set<Class<?>> loadedClasses = SetUtils.newLinkedHashSet();
        for (String classPath : classPaths) {
            loadedClasses.addAll(ClassLoaderUtils.findLoadedClassesInClassPath(classLoader, classPath));
        }
        return loadedClasses;
    }

    @Nonnull
    @Immutable
    public static Set<Class<?>> findLoadedClassesInClassPath(@Nullable ClassLoader classLoader, String classPath) throws UnsupportedOperationException {
        Set<String> classNames = ClassDataRepository.INSTANCE.getClassNamesInClassPath(classPath, true);
        return ClassLoaderUtils.findLoadedClasses(classLoader, classNames);
    }

    public static boolean isPresent(@Nullable String className) {
        return ClassLoaderUtils.resolveClass(className) != null;
    }

    public static boolean isPresent(@Nullable String className, @Nullable ClassLoader classLoader) {
        return ClassLoaderUtils.resolveClass(className, classLoader) != null;
    }

    @Nullable
    public static Class<?> resolveClass(@Nullable String className) {
        return ClassLoaderUtils.resolveClass(className, ClassLoaderUtils.getDefaultClassLoader());
    }

    @Nullable
    public static Class<?> resolveClass(@Nullable String className, @Nullable ClassLoader classLoader) {
        return ClassLoaderUtils.resolveClass(className, classLoader, false);
    }

    @Nullable
    public static Class<?> resolveClass(@Nullable String className, @Nullable ClassLoader classLoader, boolean cached) {
        if (StringUtils.isBlank(className)) {
            return null;
        }
        Class<?> targetClass = null;
        try {
            ClassLoader targetClassLoader = classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
            targetClass = ClassLoaderUtils.loadClass(targetClassLoader, className, cached);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return targetClass;
    }

    @Nonnull
    @Immutable
    public static Set<URL> findAllClassPathURLs(@Nullable ClassLoader classLoader) {
        ClassLoader actualClassLoader = ClassLoaderUtils.findClassLoader(classLoader);
        Set<URL> allClassPathURLs = SetUtils.newLinkedHashSet();
        URL[] classPathURLs = urlClassPathHandle.getURLs(actualClassLoader);
        CollectionUtils.addAll(allClassPathURLs, classPathURLs);
        ClassLoader parentClassLoader = actualClassLoader.getParent();
        if (parentClassLoader != null) {
            allClassPathURLs.addAll(ClassLoaderUtils.findAllClassPathURLs(parentClassLoader));
        }
        return Collections.unmodifiableSet(allClassPathURLs);
    }

    public static boolean removeClassPathURL(@Nullable ClassLoader classLoader, URL url) {
        if (!(classLoader instanceof SecureClassLoader)) {
            return false;
        }
        return urlClassPathHandle.removeURL(classLoader, url);
    }

    @Nullable
    public static URLClassLoader findURLClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        URLClassLoader urlClassLoader = null;
        urlClassLoader = classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : ClassLoaderUtils.findURLClassLoader(classLoader.getParent());
        return urlClassLoader;
    }

    @Nonnull
    public static URLClassLoader newURLClassLoader(@Nonnull Iterable<URL> urls) {
        return ClassLoaderUtils.newURLClassLoader(urls, null);
    }

    public static URLClassLoader newURLClassLoader(@Nonnull Iterable<URL> urls, @Nullable ClassLoader classLoader) {
        Assert.assertNotNull(urls, () -> "The 'urls' must not be null");
        URL[] urlsArray = ArrayUtils.asArray(urls, URL.class);
        return ClassLoaderUtils.newURLClassLoader(urlsArray, classLoader);
    }

    @Nonnull
    public static URLClassLoader newURLClassLoader(@Nonnull URL[] urls) {
        return ClassLoaderUtils.newURLClassLoader(urls, null);
    }

    @Nonnull
    public static URLClassLoader newURLClassLoader(@Nonnull URL[] urls, boolean initializedLoaders) {
        return ClassLoaderUtils.newURLClassLoader(urls, null, initializedLoaders);
    }

    @Nonnull
    public static URLClassLoader newURLClassLoader(@Nonnull URL[] urls, @Nullable ClassLoader parent) throws IllegalArgumentException {
        return ClassLoaderUtils.newURLClassLoader(urls, parent, false);
    }

    @Nonnull
    public static URLClassLoader newURLClassLoader(@Nonnull URL[] urls, @Nullable ClassLoader parent, boolean initializedLoaders) throws IllegalArgumentException {
        Assert.assertNotNull((Object)urls, () -> "The 'urls' must not be null");
        Assert.assertNoNullElements((Object[])urls, () -> "Any element of 'urls' must not be null");
        URLClassLoader urlClassLoader = new URLClassLoader(urls, parent);
        if (initializedLoaders) {
            urlClassPathHandle.initializeLoaders(urlClassLoader);
        }
        return urlClassLoader;
    }

    @Nonnull
    public static URLClassLoader resolveURLClassLoader(@Nullable ClassLoader classLoader) {
        URLClassLoader urlClassLoader = ClassLoaderUtils.findURLClassLoader(classLoader);
        if (urlClassLoader == null) {
            Set<URL> urls = ClassLoaderUtils.findAllClassPathURLs(classLoader);
            urlClassLoader = ClassLoaderUtils.newURLClassLoader(urls, classLoader);
        }
        return urlClassLoader;
    }

    static ClassLoader getCallerClassLoader(int invocationFrame) {
        ClassLoader classLoader = null;
        Class<?> callerClass = ReflectionUtils.getCallerClass(invocationFrame);
        if (callerClass != null) {
            classLoader = callerClass.getClassLoader();
        }
        return classLoader;
    }

    @Nullable
    static ClassLoader findClassLoader(@Nullable ClassLoader classLoader) {
        return classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
    }

    static Class<?> invokeFindLoadedClassMethod(ClassLoader classLoader, String className) {
        Class loadedClass = null;
        try {
            Method findLoadedClassMethod = MethodUtils.findMethod(ClassLoader.class, findLoadedClassMethodName, String.class);
            loadedClass = (Class)MethodUtils.invokeMethod((Object)classLoader, findLoadedClassMethod, className);
        }
        catch (Throwable e) {
            ClassLoaderUtils.logOnFindLoadedClassInvocationFailed(classLoader, className, e);
        }
        return loadedClass;
    }

    static void logOnFindLoadedClassInvocationFailed(ClassLoader classLoader, String className, Throwable e) {
        logger.error("The findLoadedClass(className : '{}' : String) method of java.lang.ClassLoader[{}] can't be invoked in the current JVM[vendor : {} , version : {}]", className, classLoader, SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VERSION, e);
    }

    static String buildCacheKey(ClassLoader classLoader, String className) {
        String cacheKey = className + classLoader.hashCode();
        return cacheKey;
    }

    private ClassLoaderUtils() {
    }

    public static enum ResourceType {
        DEFAULT{

            @Override
            boolean supports(String name) {
                return true;
            }

            @Override
            public String normalize(String name) {
                return name;
            }
        }
        ,
        CLASS{

            @Override
            boolean supports(String name) {
                return StringUtils.endsWith(name, ".class");
            }

            @Override
            public String normalize(String name) {
                if (name == null) {
                    return null;
                }
                int index = name.lastIndexOf(".class");
                String className = index > -1 ? name.substring(0, index) : name;
                className = className.replace('.', '/');
                return className + ".class";
            }
        }
        ,
        PACKAGE{

            @Override
            boolean supports(String name) {
                if (name == null) {
                    return false;
                }
                return !CLASS.supports(name) && !StringUtils.contains(name, "/") && !StringUtils.contains(name, "\\");
            }

            @Override
            String normalize(String name) {
                if (name == null) {
                    return null;
                }
                String packageName = name.replace('.', '/');
                if (!packageName.endsWith("/")) {
                    return packageName + "/";
                }
                return packageName;
            }
        };


        public String resolve(String name) {
            if (StringUtils.isBlank(name) || !this.supports(name)) {
                return null;
            }
            String normalizedName = this.normalize(name);
            normalizedName = URLUtils.normalizePath(normalizedName);
            while (normalizedName.startsWith("/")) {
                normalizedName = normalizedName.substring(1);
            }
            return normalizedName;
        }

        abstract boolean supports(String var1);

        abstract String normalize(String var1);
    }
}

