/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.filter.ClassFileJarEntryFilter;
import io.microsphere.filter.JarEntryFilter;
import io.microsphere.io.FileUtils;
import io.microsphere.io.filter.FileExtensionFilter;
import io.microsphere.io.scanner.SimpleFileScanner;
import io.microsphere.io.scanner.SimpleJarEntryScanner;
import io.microsphere.lang.function.Predicates;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.net.URLUtils;
import io.microsphere.reflect.ConstructorUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.TypeFinder;
import io.microsphere.util.Utils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ClassUtils
implements Utils {
    private static final Logger logger;
    @Nonnull
    @Immutable
    public static final String ARRAY_SUFFIX = "[]";
    @Nonnull
    @Immutable
    private static final Class<?>[] PRIMITIVE_TYPES_ARRAY;
    @Nonnull
    @Immutable
    private static final Class<?>[] WRAPPER_TYPES_ARRAY;
    @Nonnull
    @Immutable
    public static final Set<Class<?>> PRIMITIVE_TYPES;
    @Nonnull
    @Immutable
    public static final Set<Class<?>> WRAPPER_TYPES;
    @Nonnull
    @Immutable
    public static final Set<Class<?>> PRIMITIVE_ARRAY_TYPES;
    @Immutable
    public static final Set<Class<?>> SIMPLE_TYPES;
    @Immutable
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES_MAP;
    @Immutable
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES_MAP;
    @Immutable
    private static final Map<String, Class<?>> NAME_TO_TYPE_PRIMITIVE_MAP;
    static final Map<Class<?>, Boolean> concreteClassCache;
    private static final FileExtensionFilter JAR_FILE_EXTENSION_FILTER;

    public static boolean isArray(Object object) {
        return ClassUtils.isArray(ClassUtils.getClass(object));
    }

    public static boolean isArray(@Nullable Class<?> type) {
        return type != null && type.isArray();
    }

    public static boolean isConcreteClass(@Nullable Class<?> type) {
        if (type == null) {
            return false;
        }
        if (concreteClassCache.containsKey(type)) {
            return true;
        }
        if (ClassUtils.isGeneralClass(type, Boolean.FALSE)) {
            concreteClassCache.put(type, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static boolean isAbstractClass(@Nullable Class<?> type) {
        return ClassUtils.isGeneralClass(type, Boolean.TRUE);
    }

    public static boolean isGeneralClass(@Nullable Class<?> type) {
        return ClassUtils.isGeneralClass(type, Boolean.FALSE);
    }

    protected static boolean isGeneralClass(@Nullable Class<?> type, @Nullable Boolean isAbstract) {
        if (type == null) {
            return false;
        }
        int mod = type.getModifiers();
        if (io.microsphere.reflect.Modifier.isAnnotation(mod) || io.microsphere.reflect.Modifier.isEnum(mod) || Modifier.isInterface(mod) || io.microsphere.reflect.Modifier.isSynthetic(mod) || ClassUtils.isPrimitive(type) || ClassUtils.isArray(type)) {
            return false;
        }
        if (isAbstract != null) {
            return Modifier.isAbstract(mod) == isAbstract;
        }
        return true;
    }

    public static boolean isTopLevelClass(@Nullable Class<?> type) {
        return type != null && !type.isLocalClass() && !type.isMemberClass();
    }

    public static boolean isPrimitive(@Nullable Class<?> type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isFinal(@Nullable Class<?> type) {
        return type != null && Modifier.isFinal(type.getModifiers());
    }

    public static boolean isSimpleType(@Nullable Object object) {
        return ClassUtils.isSimpleType(ClassUtils.getClass(object));
    }

    public static boolean isSimpleType(@Nullable Class<?> type) {
        return SIMPLE_TYPES.contains(type);
    }

    public static boolean isCharSequence(@Nullable Object value) {
        return value instanceof CharSequence;
    }

    public static boolean isCharSequence(@Nullable Class<?> type) {
        return ClassUtils.isAssignableFrom(CharSequence.class, type);
    }

    public static boolean isNumber(@Nullable Object value) {
        return value instanceof Number;
    }

    public static boolean isNumber(@Nullable Class<?> type) {
        return ClassUtils.isAssignableFrom(Number.class, type);
    }

    public static boolean isClass(@Nullable Object object) {
        return object instanceof Class;
    }

    public static boolean isEnum(@Nullable Object object) {
        return object instanceof Enum;
    }

    public static boolean isEnum(@Nullable Class<?> type) {
        return type != null && type.isEnum();
    }

    @Nullable
    public static Class<?> resolvePrimitiveType(@Nullable Class<?> type) {
        if (ClassUtils.isPrimitive(type)) {
            return type;
        }
        return WRAPPER_TO_PRIMITIVE_TYPES_MAP.get(type);
    }

    @Nullable
    public static Class<?> resolveWrapperType(@Nullable Class<?> primitiveType) {
        return ClassUtils.tryResolveWrapperType(primitiveType, null);
    }

    public static Class<?> tryResolveWrapperType(@Nullable Class<?> primitiveType) {
        return ClassUtils.tryResolveWrapperType(primitiveType, primitiveType);
    }

    protected static Class<?> tryResolveWrapperType(@Nullable Class<?> type, @Nullable Class<?> defaultType) {
        if (ClassUtils.isWrapperType(type)) {
            return type;
        }
        return PRIMITIVE_TO_WRAPPER_TYPES_MAP.getOrDefault(type, defaultType);
    }

    public static boolean isWrapperType(@Nullable Object value) {
        return ClassUtils.isWrapperType(ClassUtils.getClass(value));
    }

    public static boolean isWrapperType(@Nullable Class<?> type) {
        return WRAPPER_TYPES.contains(type);
    }

    public static boolean arrayTypeEquals(@Nullable Class<?> oneArrayType, @Nullable Class<?> anotherArrayType) {
        if (!ClassUtils.isArray(oneArrayType) || !ClassUtils.isArray(anotherArrayType)) {
            return false;
        }
        Class<?> oneComponentType = oneArrayType.getComponentType();
        Class<?> anotherComponentType = anotherArrayType.getComponentType();
        if (ClassUtils.isArray(oneComponentType) && ClassUtils.isArray(anotherComponentType)) {
            return ClassUtils.arrayTypeEquals(oneComponentType, anotherComponentType);
        }
        return Objects.equals(oneComponentType, anotherComponentType);
    }

    @Nullable
    public static Class<?> resolvePrimitiveClassForName(@Nullable String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = NAME_TO_TYPE_PRIMITIVE_MAP.get(name);
        }
        return result;
    }

    @Nullable
    public static String resolvePackageName(@Nullable Class<?> targetClass) {
        return ClassUtils.isPrimitive(targetClass) ? null : ClassUtils.resolvePackageName(ClassUtils.getTypeName(targetClass));
    }

    @Nonnull
    public static String resolvePackageName(@Nullable String className) {
        return StringUtils.substringBeforeLast(className, ".");
    }

    @Nonnull
    @Immutable
    public static Set<String> findClassNamesInClassPath(@Nullable String classPath, boolean recursive) {
        String protocol = URLUtils.resolveProtocol(classPath);
        String resolvedClassPath = "file".equals(protocol) ? StringUtils.substringBetween(classPath, protocol + ':', "!/") : classPath;
        File classesFileHolder = new File(resolvedClassPath);
        return ClassUtils.findClassNamesInClassPath(classesFileHolder, recursive);
    }

    @Nonnull
    @Immutable
    public static Set<String> findClassNamesInClassPath(@Nullable File classPath, boolean recursive) {
        if (classPath == null || !classPath.exists()) {
            return Collections.emptySet();
        }
        Set<String> classNames = Collections.emptySet();
        if (classPath.isDirectory()) {
            classNames = ClassUtils.findClassNamesInDirectory(classPath, recursive);
        } else if (classPath.isFile() && JAR_FILE_EXTENSION_FILTER.accept(classPath)) {
            classNames = ClassUtils.findClassNamesInJarFile(classPath, recursive);
        }
        if (CollectionUtils.isEmpty(classNames) && logger.isTraceEnabled()) {
            logger.trace("No Class was found in the classPath : '{}' , recursive : {}", classPath, recursive);
        }
        return classNames;
    }

    @Nonnull
    @Immutable
    public static Set<String> findClassNamesInDirectory(@Nullable File classesDirectory, boolean recursive) {
        if (classesDirectory == null || !classesDirectory.exists()) {
            return Collections.emptySet();
        }
        Set<File> classFiles = SimpleFileScanner.INSTANCE.scan(classesDirectory, recursive, FileExtensionFilter.of("class"));
        if (CollectionUtils.isEmpty(classFiles)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (File classFile : classFiles) {
            String className = ClassUtils.resolveClassName(classesDirectory, classFile);
            classNames.add(className);
        }
        return Collections.unmodifiableSet(classNames);
    }

    @Nonnull
    @Immutable
    public static Set<String> findClassNamesInJarFile(@Nullable File jarFile, boolean recursive) {
        Set<String> classNames;
        block6: {
            if (jarFile == null || !jarFile.exists()) {
                return Collections.emptySet();
            }
            try {
                JarFile jarFile_ = new JarFile(jarFile);
                Set<JarEntry> jarEntries = SimpleJarEntryScanner.INSTANCE.scan(jarFile_, recursive, (JarEntryFilter)ClassFileJarEntryFilter.INSTANCE);
                if (CollectionUtils.isEmpty(jarEntries)) {
                    classNames = Collections.emptySet();
                } else {
                    classNames = SetUtils.newLinkedHashSet();
                    for (JarEntry jarEntry : jarEntries) {
                        String jarEntryName = jarEntry.getName();
                        String className = ClassUtils.resolveClassName(jarEntryName);
                        if (!StringUtils.isNotBlank(className)) continue;
                        classNames.add(className);
                    }
                    classNames = Collections.unmodifiableSet(classNames);
                }
            }
            catch (Exception e) {
                classNames = Collections.emptySet();
                if (!logger.isTraceEnabled()) break block6;
                logger.trace("The class names can't be resolved by SimpleJarEntryScanner#scan(jarFile = {} , recursive = {} , jarEntryFilter = ClassFileJarEntryFilter)", jarFile, recursive, e);
            }
        }
        return classNames;
    }

    protected static String resolveClassName(File classesDirectory, File classFile) {
        String classFileRelativePath = FileUtils.resolveRelativePath(classesDirectory, classFile);
        return ClassUtils.resolveClassName(classFileRelativePath);
    }

    @Nullable
    public static String resolveClassName(@Nullable String resourceName) {
        if (resourceName == null) {
            return null;
        }
        String className = StringUtils.replace(resourceName, "/", ".");
        className = StringUtils.substringBefore(className, ".class");
        while (StringUtils.startsWith(className, ".")) {
            className = StringUtils.substringAfter(className, ".");
        }
        return className;
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> getAllSuperClasses(@Nullable Class<?> type) {
        return ClassUtils.findAllSuperClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> getAllInterfaces(@Nullable Class<?> type) {
        return ClassUtils.findAllInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> getAllInheritedTypes(@Nullable Class<?> type) {
        return ClassUtils.getAllInheritedClasses(type);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> getAllInheritedClasses(@Nullable Class<?> type) {
        return ClassUtils.findAllInheritedClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static List<Class<?>> getAllClasses(@Nullable Class<?> type) {
        return ClassUtils.findAllClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> findAllSuperClasses(@Nullable Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, false, true, true, false, classFilters);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> findAllInterfaces(@Nullable Class<?> type, Predicate<? super Class<?>> ... interfaceFilters) {
        return ClassUtils.findTypes(type, false, true, false, true, interfaceFilters);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> findAllInheritedClasses(@Nullable Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, false, true, true, true, classFilters);
    }

    @Nonnull
    @Immutable
    public static List<Class<?>> findAllClasses(@Nullable Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, true, true, true, true, classFilters);
    }

    @Nonnull
    @Immutable
    protected static List<Class<?>> findTypes(@Nullable Class<?> type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeGenericSuperclass, boolean includeGenericInterfaces, Predicate<? super Class<?>> ... typeFilters) {
        if (type == null || ClassUtils.isPrimitive(type)) {
            return Collections.emptyList();
        }
        return TypeFinder.classFinder(type, includeSelf, includeHierarchicalTypes, includeGenericSuperclass, includeGenericInterfaces).findTypes(typeFilters);
    }

    public static boolean isAssignableFrom(@Nullable Class<?> superType, @Nullable Class<?> targetType) {
        if (superType == null || targetType == null) {
            return false;
        }
        if (Objects.equals(superType, targetType)) {
            return true;
        }
        return superType.isAssignableFrom(targetType);
    }

    @Nullable
    public static Class<?> getType(@Nullable Object value) {
        return ClassUtils.getClass(value);
    }

    @Nullable
    public static Class<?> getClass(@Nullable Object object) {
        return object == null ? null : object.getClass();
    }

    @Nonnull
    public static Class[] getTypes(Object ... values) {
        return ClassUtils.getClasses(values);
    }

    @Nonnull
    public static Class<?>[] getClasses(Object ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int size = values.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            types[i] = ClassUtils.getClass(values[i]);
        }
        return types;
    }

    @Nullable
    public static String getTypeName(@Nullable Object value) {
        return ClassUtils.getTypeName(ClassUtils.getClass(value));
    }

    @Nullable
    public static String getTypeName(@Nullable Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                String name = ClassUtils.getTypeName(cl);
                StringBuilder sb = new StringBuilder(name.length() + dimensions * 2);
                sb.append(name);
                for (int i = 0; i < dimensions; ++i) {
                    sb.append(ARRAY_SUFFIX);
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    @Nullable
    public static String getSimpleName(@Nullable Class<?> type) {
        if (type == null) {
            return null;
        }
        boolean array = type.isArray();
        return ClassUtils.getSimpleName(type, array);
    }

    private static String getSimpleName(Class<?> type, boolean array) {
        if (array) {
            return ClassUtils.getSimpleName(type.getComponentType()) + ARRAY_SUFFIX;
        }
        String simpleName = type.getName();
        Class<?> enclosingClass = type.getEnclosingClass();
        if (enclosingClass != null) {
            int index;
            String ecName = enclosingClass.getName();
            int length = (simpleName = simpleName.substring(ecName.length())).length();
            if (length < 1 || simpleName.charAt(0) != '$') {
                throw new InternalError("Malformed class name");
            }
            for (index = 1; index < length && ClassUtils.isAsciiDigit(simpleName.charAt(index)); ++index) {
            }
            return simpleName.substring(index);
        }
        simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
        return simpleName;
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isDerived(@Nullable Class<?> targetType, Class<?> ... superTypes) {
        if (targetType == null) {
            return false;
        }
        int length = ArrayUtils.length(superTypes);
        if (length == 0) {
            return false;
        }
        boolean derived = false;
        for (int i = 0; i < length; ++i) {
            Class<?> superType = superTypes[i];
            if (!ClassUtils.isAssignableFrom(superType, targetType)) continue;
            derived = true;
            break;
        }
        return derived;
    }

    @Nonnull
    public static <T> T newInstance(@Nonnull Class<T> type, Object ... args) {
        int length = ArrayUtils.length(args);
        List<Constructor<?>> constructors = ConstructorUtils.findDeclaredConstructors(type, constructor -> {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (length != parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object arg = args[i];
                Class<?> parameterType = parameterTypes[i];
                if (ClassUtils.isPrimitive(parameterType)) {
                    parameterType = ClassUtils.resolveWrapperType(parameterType);
                }
                if (parameterType.isInstance(arg)) continue;
                return false;
            }
            return true;
        });
        if (constructors.isEmpty()) {
            String message = FormatUtils.format("No constructor[class : '{}'] matches the arguments : {}", ClassUtils.getTypeName(type), ArrayUtils.arrayToString(args));
            throw new IllegalArgumentException(message);
        }
        Constructor<?> constructor2 = constructors.get(0);
        return (T)ConstructorUtils.newInstance(constructor2, args);
    }

    @Nullable
    public static Class<?> getTopComponentType(@Nullable Object array) {
        return ClassUtils.getTopComponentType(ClassUtils.getClass(array));
    }

    @Nullable
    public static Class<?> getTopComponentType(@Nullable Class<?> arrayType) {
        if (!ClassUtils.isArray(arrayType)) {
            return null;
        }
        Class<?> targetType = null;
        Class<?> componentType = arrayType.getComponentType();
        while (componentType != null) {
            targetType = componentType;
            componentType = ClassUtils.getTopComponentType(componentType);
        }
        return targetType;
    }

    @Nullable
    public static <T> T cast(@Nullable Object object, @Nullable Class<T> castType) {
        if (object == null || castType == null) {
            return null;
        }
        return castType.isInstance(object) ? (T)castType.cast(object) : null;
    }

    private ClassUtils() {
    }

    static {
        int i;
        logger = LoggerFactory.getLogger(ClassUtils.class);
        PRIMITIVE_TYPES_ARRAY = ArrayUtils.ofArray(Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
        WRAPPER_TYPES_ARRAY = ArrayUtils.ofArray(Void.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class);
        PRIMITIVE_TYPES = SetUtils.ofSet(PRIMITIVE_TYPES_ARRAY);
        WRAPPER_TYPES = SetUtils.ofSet(WRAPPER_TYPES_ARRAY);
        PRIMITIVE_ARRAY_TYPES = SetUtils.ofSet(boolean[].class, char[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class);
        Class[] otherSimpleTypes = ArrayUtils.ofArray(String.class, BigDecimal.class, BigInteger.class, Date.class, Object.class);
        Set simpleTypes = SetUtils.newFixedLinkedHashSet(WRAPPER_TYPES_ARRAY.length + otherSimpleTypes.length);
        Collections.addAll(simpleTypes, WRAPPER_TYPES_ARRAY);
        Collections.addAll(simpleTypes, otherSimpleTypes);
        SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        int size = WRAPPER_TYPES_ARRAY.length;
        Map<Class<?>, Class<?>> wrapperToPrimitiveTypesMap = MapUtils.newFixedLinkedHashMap(size);
        for (i = 0; i < size; ++i) {
            Class<?> wrapperType = WRAPPER_TYPES_ARRAY[i];
            Class<?> primitiveType = PRIMITIVE_TYPES_ARRAY[i];
            wrapperToPrimitiveTypesMap.put(wrapperType, primitiveType);
        }
        WRAPPER_TO_PRIMITIVE_TYPES_MAP = Collections.unmodifiableMap(wrapperToPrimitiveTypesMap);
        size = PRIMITIVE_TYPES_ARRAY.length;
        Map<Class<?>, Class<?>> primitiveToWrapperTypesMap = MapUtils.newFixedLinkedHashMap(size);
        for (i = 0; i < size; ++i) {
            Class<?> primitiveType = PRIMITIVE_TYPES_ARRAY[i];
            Class<?> wrapperType = WRAPPER_TYPES_ARRAY[i];
            primitiveToWrapperTypesMap.put(primitiveType, wrapperType);
        }
        PRIMITIVE_TO_WRAPPER_TYPES_MAP = Collections.unmodifiableMap(primitiveToWrapperTypesMap);
        Map primitiveTypeNameMap = MapUtils.newFixedLinkedHashMap(PRIMITIVE_TYPES.size() + PRIMITIVE_ARRAY_TYPES.size());
        PRIMITIVE_TYPES.forEach(type -> primitiveTypeNameMap.put(type.getName(), type));
        PRIMITIVE_ARRAY_TYPES.forEach(type -> primitiveTypeNameMap.put(type.getName(), type));
        NAME_TO_TYPE_PRIMITIVE_MAP = Collections.unmodifiableMap(primitiveTypeNameMap);
        concreteClassCache = Collections.synchronizedMap(new WeakHashMap());
        JAR_FILE_EXTENSION_FILTER = FileExtensionFilter.of(".jar");
    }
}

