/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nullable;
import io.microsphere.util.Version;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Compatible<T, R> {
    private final Version version;
    private final Function<Version, R> conditionalFunction;

    public Compatible(Version version, Function<Version, R> conditionalFunction) {
        this.version = version;
        this.conditionalFunction = conditionalFunction;
    }

    public static <T> Compatible<T, ?> of(Class<T> targetClass) {
        return new Compatible(Version.getVersion(targetClass), null);
    }

    public <R> Compatible<T, R> on(String operator, String comparedVersion, Function<Version, R> conditionalFunction) {
        return this.on(Version.Operator.of(operator), Version.of(comparedVersion), conditionalFunction);
    }

    public <R> Compatible<T, R> on(Version.Operator operator, Version comparedVersion, Function<Version, R> conditionalFunction) {
        if (Boolean.TRUE.equals(operator.test(this.version, comparedVersion))) {
            return new Compatible<T, R>(this.version, conditionalFunction);
        }
        return this;
    }

    public Optional<R> call() {
        Object result = null;
        if (this.conditionalFunction != null) {
            result = this.conditionalFunction.apply(this.version);
        }
        return Optional.ofNullable(result);
    }

    public void accept(Consumer<R> resultConsumer) {
        this.call().ifPresent(resultConsumer);
    }

    @Nullable
    public R get() {
        return this.call().orElse(null);
    }
}

