/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.io.StringBuilderWriter;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class ExceptionUtils
implements Utils {
    @Nonnull
    public static String getStackTrace(Throwable throwable) {
        StringBuilderWriter sw = new StringBuilderWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    @Nonnull
    public static <T extends Throwable, TT extends Throwable> TT wrap(T source, Class<TT> thrownType) {
        if (ClassUtils.isAssignableFrom(thrownType, source.getClass())) {
            return (TT)source;
        }
        Object[] args = ExceptionUtils.resolveArguments(source);
        return (TT)((Throwable)ClassUtils.newInstance(thrownType, args));
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass) {
        return (T)((Throwable)ClassUtils.newInstance(throwableClass, new Object[0]));
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass, String message) {
        return (T)((Throwable)ClassUtils.newInstance(throwableClass, message));
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass, Throwable cause) {
        return (T)((Throwable)ClassUtils.newInstance(throwableClass, cause));
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass, String message, Throwable cause) {
        return (T)((Throwable)ClassUtils.newInstance(throwableClass, message, cause));
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass, Throwable cause, String messagePattern, Object ... args) {
        String message = FormatUtils.format(messagePattern, args);
        return ExceptionUtils.create(throwableClass, message, cause);
    }

    @Nonnull
    public static <T extends Throwable> T create(Class<T> throwableClass, Object ... args) {
        return (T)((Throwable)ClassUtils.newInstance(throwableClass, args));
    }

    @Nonnull
    public static <T extends Throwable, TT extends Throwable> TT throwTarget(T source, Class<TT> thrownType) throws TT {
        throw ExceptionUtils.wrap(source, thrownType);
    }

    private static <T extends Throwable> Object[] resolveArguments(T source) {
        Object[] objectArray;
        Object cause;
        String message = source.getMessage();
        Object object = cause = source.getCause() == null ? source : source.getCause();
        if (message == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = cause;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = message;
            objectArray = objectArray3;
            objectArray3[1] = cause;
        }
        return objectArray;
    }

    private ExceptionUtils() {
    }
}

