/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.util.function.Consumer;

public abstract class IterableUtils
implements Utils {
    public static boolean isIterable(@Nullable Object object) {
        return object instanceof Iterable;
    }

    public static boolean isIterable(@Nullable Class<?> clazz) {
        return ClassUtils.isAssignableFrom(Iterable.class, clazz);
    }

    public static <E> void iterate(@Nullable Iterable<E> elements, @Nonnull Consumer<E> elementConsumer) {
        if (elements != null) {
            for (E element : elements) {
                elementConsumer.accept(element);
            }
        }
    }

    public static <E> void forEach(@Nullable Iterable<E> elements, @Nonnull Consumer<E> elementConsumer) {
        IterableUtils.iterate(elements, elementConsumer);
    }

    private IterableUtils() {
    }
}

