/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.AnnotationUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.util.Comparator;
import java.util.Objects;

public class PriorityComparator
implements Comparator<Object> {
    private static final Class PRIORITY_CLASS = ClassLoaderUtils.resolveClass("javax.annotation.Priority");
    private static final int UNDEFINED_VALUE = -1;
    public static final PriorityComparator INSTANCE = new PriorityComparator();

    @Override
    public int compare(Object o1, Object o2) {
        return PriorityComparator.compare(PriorityComparator.asClass(o1), PriorityComparator.asClass(o2));
    }

    public static int compare(Class<?> type1, Class<?> type2) {
        if (Objects.equals(type1, type2) || PRIORITY_CLASS == null) {
            return 0;
        }
        Object priority1 = AnnotationUtils.findAnnotation(type1, PRIORITY_CLASS);
        Object priority2 = AnnotationUtils.findAnnotation(type2, PRIORITY_CLASS);
        int priorityValue1 = PriorityComparator.getValue(priority1);
        int priorityValue2 = PriorityComparator.getValue(priority2);
        return Integer.compare(priorityValue1, priorityValue2);
    }

    private static Class<?> asClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    private static int getValue(Object priority) {
        int value = priority == null ? -1 : (Integer)MethodUtils.invokeMethod(priority, "value", new Object[0]);
        return value < 0 ? -1 : value;
    }
}

