/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.util.PropertyResourceBundleControl;
import io.microsphere.util.SystemUtils;
import io.microsphere.util.Utils;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class PropertyResourceBundleUtils
implements Utils {
    public static final String DEFAULT_ENCODING_PROPERTY_NAME = "java.util.PropertyResourceBundle.encoding";
    public static final String DEFAULT_ENCODING = System.getProperty("java.util.PropertyResourceBundle.encoding", SystemUtils.FILE_ENCODING);

    @Nonnull
    public static ResourceBundle getBundle(String baseName) {
        return PropertyResourceBundleUtils.getBundle(baseName, DEFAULT_ENCODING);
    }

    @Nonnull
    public static ResourceBundle getBundle(String baseName, String encoding) {
        return PropertyResourceBundleUtils.getBundle(baseName, Locale.getDefault(), encoding);
    }

    @Nonnull
    public static ResourceBundle getBundle(String baseName, Locale locale, String encoding) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return PropertyResourceBundleUtils.getBundle(baseName, locale, classLoader, encoding);
    }

    @Nonnull
    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader, String encoding) {
        ResourceBundle.Control control = PropertyResourceBundleControl.newControl(encoding);
        return ResourceBundle.getBundle(baseName, locale, classLoader, control);
    }

    private PropertyResourceBundleUtils() {
    }
}

