/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.ConfigurationProperty;
import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentMap;

public abstract class ServiceLoaderUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaderUtils.class);
    public static final String DEFAULT_SERVICE_LOADER_CACHED_PROPERTY_VALUE = "false";
    public static final String SERVICE_LOADER_CACHED_PROPERTY_NAME = "microsphere.service-loader.cached";
    @ConfigurationProperty(name="microsphere.service-loader.cached", defaultValue="false", description="Whether to cache the loaded services", source={"system-properties"})
    public static final boolean SERVICE_LOADER_CACHED = Boolean.parseBoolean(System.getProperty("microsphere.service-loader.cached", "false"));
    private static final ConcurrentMap<Class<?>, List<?>> servicesCache = MapUtils.newConcurrentHashMap();

    @Nonnull
    @Immutable
    public static <S> List<S> loadServicesList(Class<S> serviceType) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServicesList(serviceType, ClassLoaderUtils.getClassLoader(serviceType));
    }

    @Nonnull
    @Immutable
    public static <S> List<S> loadServicesList(Class<S> serviceType, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServicesList(serviceType, classLoader, SERVICE_LOADER_CACHED);
    }

    @Nonnull
    @Immutable
    public static <S> List<S> loadServicesList(Class<S> serviceType, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServicesList(serviceType, ClassLoaderUtils.getClassLoader(serviceType), cached);
    }

    @Nonnull
    @Immutable
    public static <S> List<S> loadServicesList(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached) throws IllegalArgumentException {
        return Collections.unmodifiableList(ServiceLoaderUtils.loadServicesAsList(serviceType, classLoader, cached));
    }

    @Nonnull
    public static <S> S[] loadServices(Class<S> serviceType) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServices(serviceType, ClassLoaderUtils.getClassLoader(serviceType));
    }

    @Nonnull
    public static <S> S[] loadServices(Class<S> serviceType, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServices(serviceType, classLoader, SERVICE_LOADER_CACHED);
    }

    @Nonnull
    public static <S> S[] loadServices(Class<S> serviceType, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadServices(serviceType, ClassLoaderUtils.getClassLoader(serviceType), cached);
    }

    @Nonnull
    public static <S> S[] loadServices(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached) throws IllegalArgumentException {
        return ArrayUtils.asArray(ServiceLoaderUtils.loadServicesAsList(serviceType, classLoader, cached), serviceType);
    }

    @Nonnull
    public static <S> S loadFirstService(Class<S> serviceType) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadFirstService(serviceType, ClassLoaderUtils.getClassLoader(serviceType));
    }

    @Nonnull
    public static <S> S loadFirstService(Class<S> serviceType, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadFirstService(serviceType, ClassLoaderUtils.getClassLoader(serviceType), cached);
    }

    @Nonnull
    public static <S> S loadFirstService(Class<S> serviceType, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadFirstService(serviceType, classLoader, SERVICE_LOADER_CACHED);
    }

    @Nonnull
    public static <S> S loadFirstService(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadService(serviceType, classLoader, cached, true);
    }

    @Nonnull
    public static <S> S loadLastService(Class<S> serviceType) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadLastService(serviceType, ClassLoaderUtils.getClassLoader(serviceType));
    }

    @Nonnull
    public static <S> S loadLastService(Class<S> serviceType, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadLastService(serviceType, ClassLoaderUtils.getClassLoader(serviceType), cached);
    }

    @Nonnull
    public static <S> S loadLastService(Class<S> serviceType, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadLastService(serviceType, classLoader, SERVICE_LOADER_CACHED);
    }

    @Nonnull
    public static <S> S loadLastService(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached) throws IllegalArgumentException {
        return ServiceLoaderUtils.loadService(serviceType, classLoader, cached, false);
    }

    static <S> S loadService(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached, boolean first) {
        List<S> serviceList = ServiceLoaderUtils.loadServicesAsList(serviceType, classLoader, cached);
        int index = first ? 0 : serviceList.size() - 1;
        return serviceList.get(index);
    }

    static <S> List<S> loadServicesAsList(Class<S> serviceType, @Nullable ClassLoader classLoader, boolean cached) throws IllegalArgumentException {
        List serviceList = cached ? servicesCache.computeIfAbsent(serviceType, type -> ServiceLoaderUtils.loadServicesAsList(type, classLoader)) : ServiceLoaderUtils.loadServicesAsList(serviceType, classLoader);
        if (logger.isTraceEnabled()) {
            logger.trace("Loaded the service[type : '{}' , cached : {}] list : {}", serviceType, cached, serviceList);
        }
        return serviceList;
    }

    static <S> List<S> loadServicesAsList(Class<S> serviceType, @Nullable ClassLoader classLoader) {
        ServiceLoader<S> serviceLoader;
        Iterator<S> iterator;
        if (classLoader == null) {
            classLoader = ClassLoaderUtils.getClassLoader(serviceType);
        }
        if (!(iterator = (serviceLoader = ServiceLoader.load(serviceType, classLoader)).iterator()).hasNext()) {
            String className = serviceType.getName();
            String message = FormatUtils.format("No Service interface[type : {}] implementation was defined in service loader configuration file[/META-INF/services/{}] under ClassLoader[{}]", className, className, classLoader);
            throw new IllegalArgumentException(message);
        }
        LinkedList<S> serviceList = ListUtils.newLinkedList(iterator);
        Collections.sort(serviceList, Prioritized.COMPARATOR);
        return serviceList;
    }

    private ServiceLoaderUtils() {
    }
}

